/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.streams;

import io.vertx.proton.ProtonConnection;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.streams.Delivery;
import io.vertx.proton.streams.ProtonPublisher;
import io.vertx.proton.streams.ProtonPublisherOptions;
import io.vertx.proton.streams.ProtonSubscriber;
import io.vertx.proton.streams.ProtonSubscriberOptions;
import io.vertx.proton.streams.Tracker;
import io.vertx.proton.streams.impl.ProtonPublisherImpl;
import io.vertx.proton.streams.impl.ProtonPublisherWrapperImpl;
import io.vertx.proton.streams.impl.ProtonSubscriberImpl;
import io.vertx.proton.streams.impl.ProtonSubscriberWrapperImpl;
import org.apache.qpid.proton.message.Message;

public class ProtonStreams {
    public static ProtonPublisher<Delivery> createDeliveryConsumer(ProtonConnection connection, String address) {
        return ProtonStreams.createDeliveryConsumer(connection, address, new ProtonPublisherOptions());
    }

    public static ProtonPublisher<Delivery> createDeliveryConsumer(ProtonConnection connection, String address, ProtonPublisherOptions options) {
        return new ProtonPublisherImpl(address, (ProtonConnectionImpl)connection, options);
    }

    public static ProtonPublisher<Message> createConsumer(ProtonConnection connection, String address) {
        return ProtonStreams.createConsumer(connection, address, new ProtonPublisherOptions());
    }

    public static ProtonPublisher<Message> createConsumer(ProtonConnection connection, String address, ProtonPublisherOptions options) {
        ProtonPublisherImpl publisher = new ProtonPublisherImpl(address, (ProtonConnectionImpl)connection, options);
        return new ProtonPublisherWrapperImpl(publisher);
    }

    public static ProtonSubscriber<Tracker> createTrackerProducer(ProtonConnection connection, String address) {
        return new ProtonSubscriberImpl(address, (ProtonConnectionImpl)connection);
    }

    public static ProtonSubscriber<Tracker> createTrackerProducer(ProtonConnection connection, String address, ProtonSubscriberOptions options) {
        return new ProtonSubscriberImpl(address, (ProtonConnectionImpl)connection, options);
    }

    public static ProtonSubscriber<Message> createProducer(ProtonConnection connection, String address) {
        ProtonSubscriberImpl subscriber = new ProtonSubscriberImpl(address, (ProtonConnectionImpl)connection);
        return new ProtonSubscriberWrapperImpl(subscriber);
    }

    public static ProtonSubscriber<Message> createProducer(ProtonConnection connection, String address, ProtonSubscriberOptions options) {
        ProtonSubscriberImpl subscriber = new ProtonSubscriberImpl(address, (ProtonConnectionImpl)connection, options);
        return new ProtonSubscriberWrapperImpl(subscriber);
    }
}

