/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;

@Singleton
public class KubernetesClientProducer {
    private KubernetesClient client;

    @DefaultBean
    @Singleton
    @Produces
    public KubernetesClient kubernetesClient(KubernetesSerialization kubernetesSerialization, Config config) {
        this.client = new KubernetesClientBuilder().withKubernetesSerialization(kubernetesSerialization).withConfig(config).build();
        return this.client;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

