/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.methods;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.TypeHelper;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodDescriptor;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodGenerator;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.core.Handler;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class UniMethodGenerator
extends MutinyMethodGenerator {
    private final Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap;

    public UniMethodGenerator(PrintWriter writer, Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap) {
        super(writer);
        this.methodTypeArgMap = methodTypeArgMap;
    }

    public void generate(ClassModel model, MethodInfo method) {
        MutinyMethodDescriptor uniMethod = this.computeMethodInfo(method);
        this.generateJavadoc(uniMethod);
        this.generateMethodDeclaration(uniMethod);
        this.generateBody(model, uniMethod);
        this.writer.println();
    }

    @Override
    public void generateMethodDeclaration(MutinyMethodDescriptor descriptor) {
        this.writer.print("  @CheckReturnValue\n");
        super.generateMethodDeclaration(descriptor);
    }

    public void generateDeclaration(MethodInfo method) {
        MutinyMethodDescriptor uniMethod = this.computeMethodInfo(method);
        this.generateJavadoc(uniMethod);
        this.generateMethodDeclaration(uniMethod);
        this.writer.println(";");
        this.writer.println();
    }

    public void generateOther(MethodInfo method) {
        MutinyMethodDescriptor uniMethod = this.computeMethodInfoOther(method);
        this.generateJavadoc(uniMethod);
        this.generateMethodDeclaration(uniMethod);
        this.generateBodyOther(uniMethod);
        this.writer.println();
    }

    private void generateBody(ClassModel model, MutinyMethodDescriptor descriptor) {
        MethodInfo method = descriptor.getMethod();
        ClassTypeInfo raw = method.getReturnType().getRaw();
        String methodSimpleName = raw.getSimpleName();
        String adapterType = AsyncResultUni.class.getName() + ".to" + methodSimpleName;
        List<ParamInfo> params = descriptor.getOriginalMethod().getParams();
        String handlerParameterName = params.get(params.size() - 1).getName();
        this.writer.println(" { ");
        this.writer.print("    return ");
        this.writer.print(adapterType);
        this.writer.println("(" + handlerParameterName + " -> {");
        this.writer.println("        " + UniMethodGenerator.invokeDelegate(this.methodTypeArgMap, model, descriptor.getOriginalMethod()) + ";");
        this.writer.println("    });");
        this.writer.println("  }");
    }

    public static String invokeDelegate(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, ClassModel model, MethodInfo method) {
        StringBuilder object = method.isStaticMethod() ? new StringBuilder(Helper.getNonGenericType(model.getIfaceFQCN())) : new StringBuilder("delegate");
        object.append(".").append(method.getName()).append("(");
        int index = 0;
        for (ParamInfo param : method.getParams()) {
            TypeInfo type;
            if (index > 0) {
                object.append(", ");
            }
            if ((type = param.getType()).isParameterized() && type.getRaw().getName().equals(Flow.Publisher.class.getName())) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                Object adapterFunction = parameterizedType.getArg(0).isVariable() ? "java.util.function.Function.identity()" : "obj -> (" + parameterizedType.getArg(0).getRaw().getName() + ") obj.getDelegate()";
                object.append(ReadStreamSubscriber.class.getName()).append(".asReadStream(").append(param.getName()).append(",").append((String)adapterFunction).append(").resume()");
            } else if (index < method.getParams().size() - 1 && type.isParameterized() && type.getRaw().getName().equals(Handler.class.getName()) && !TypeHelper.isHandlerOfPromise(param) && !TypeHelper.isConsumerOfPromise(param)) {
                object.append(param.getName()).append("::accept");
            } else {
                object.append(CodeGenHelper.genConvParam(methodTypeArgMap, type, method, param.getName()));
            }
            ++index;
        }
        object.append(")");
        return object.toString();
    }

    private static boolean isUni(ParamInfo param) {
        return param.getType().isParameterized() && param.getType().getRaw().getName().equals(Uni.class.getName());
    }

    private void generateBodyOther(MutinyMethodDescriptor descriptor) {
        MethodInfo method = descriptor.getMethod();
        this.writer.println(" { ");
        this.writer.print("    return " + UniHelper.class.getName() + ".toUni(delegate.");
        this.writer.print(method.getName());
        this.writer.print("(");
        List<ParamInfo> params = method.getParams();
        this.writer.print(params.stream().map(pi -> {
            if (pi.getType().getKind() == ClassKind.API) {
                return pi.getName() + ".getDelegate()";
            }
            if (pi.getType().getKind() == ClassKind.FUNCTION) {
                ParameterizedTypeInfo type = (ParameterizedTypeInfo)pi.getType();
                TypeInfo functionParamArgType = type.getArg(0);
                TypeInfo futureArgType = type.getArg(1);
                if (futureArgType.getKind() == ClassKind.FUTURE && ((ParameterizedTypeInfo)futureArgType).getArg(0).getKind() == ClassKind.API) {
                    return "\n    " + pi.getName() + ".andThen(u -> " + UniHelper.class.getName() + ".toFuture(u).map(h -> h.getDelegate()))\n";
                }
                if (functionParamArgType.getKind() == ClassKind.API && futureArgType.getKind() == ClassKind.FUTURE) {
                    return "\n\t arg -> " + UniHelper.class.getName() + ".toFuture(" + pi.getName() + ".apply(" + CodeGenHelper.genTranslatedTypeName(functionParamArgType) + ".newInstance(arg)))\n";
                }
                return pi.getName();
            }
            return pi.getName();
        }).collect(Collectors.joining(", ")));
        TypeInfo arg = ((ParameterizedTypeInfo)descriptor.getOriginalMethod().getReturnType()).getArg(0);
        if (arg.getKind() == ClassKind.API) {
            this.writer.print(").map(x -> " + arg.getSimpleName() + ".newInstance(x)));");
        } else {
            this.writer.print("));");
        }
        this.writer.println("}");
    }

    private MutinyMethodDescriptor computeMethodInfoOther(MethodInfo method) {
        TypeInfo itemType = ((ParameterizedTypeInfo)method.getReturnType()).getArg(0);
        ParameterizedTypeInfo uniReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Uni.class).getRaw(), true, Collections.singletonList(itemType));
        MethodInfo uniMethod = method.copy().setReturnType(uniReturnType);
        return new MutinyMethodDescriptor(uniMethod, method, MutinyMethodDescriptor.MutinyKind.UNI);
    }

    private MutinyMethodDescriptor computeMethodInfo(MethodInfo method) {
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>(method.getParams());
        ParamInfo handler = (ParamInfo)params.remove(method.getParams().size() - 1);
        TypeInfo uniType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)handler.getType()).getArg(0)).getArg(0);
        TypeInfo uniUnresolvedType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)handler.getUnresolvedType()).getArg(0)).getArg(0);
        ParameterizedTypeInfo uniReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Uni.class).getRaw(), uniUnresolvedType.isNullable(), Collections.singletonList(uniType));
        List<ParamInfo> updatedParameters = UniMethodGenerator.updateParamInfoIfNeeded(params);
        MethodInfo newMethod = method.copy().setReturnType(uniReturnType).setParams(updatedParameters);
        return new MutinyMethodDescriptor(newMethod, method, MutinyMethodDescriptor.MutinyKind.UNI);
    }

    static List<ParamInfo> updateParamInfoIfNeeded(List<ParamInfo> params) {
        ArrayList<ParamInfo> updatedParameters = new ArrayList<ParamInfo>();
        for (ParamInfo param : params) {
            if (UniMethodGenerator.isHandler(param)) {
                TypeInfo consumerType = ((ParameterizedTypeInfo)param.getType()).getArg(0);
                TypeInfo consumerUnresolvedType = ((ParameterizedTypeInfo)param.getUnresolvedType()).getArg(0);
                ParameterizedTypeInfo consumer = new ParameterizedTypeInfo(TypeReflectionFactory.create(Consumer.class).getRaw(), consumerUnresolvedType.isNullable(), Collections.singletonList(consumerType));
                ParamInfo pi = new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), consumer);
                updatedParameters.add(pi);
                continue;
            }
            updatedParameters.add(param);
        }
        return updatedParameters;
    }

    private static boolean isHandler(ParamInfo param) {
        TypeInfo type = param.getType();
        return type.isParameterized() && type.getRaw().getName().equals(Handler.class.getName());
    }
}

