/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import org.eclipse.hono.client.ServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceInvocationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInvocationException.class);
    private static final ResourceBundle resourceBundle;
    private static final String BUNDLE_NAME;
    private final int errorCode;
    private final String tenant;

    protected ServiceInvocationException(int errorCode) {
        this(null, errorCode, null, null);
    }

    protected ServiceInvocationException(int errorCode, String msg) {
        this(null, errorCode, msg, null);
    }

    protected ServiceInvocationException(int errorCode, Throwable cause) {
        this(null, errorCode, null, cause);
    }

    protected ServiceInvocationException(String tenant, int errorCode, String msg, Throwable cause) {
        super(ServiceInvocationException.providedOrDefaultMessage(errorCode, msg), cause);
        if (errorCode < 400 || errorCode >= 600) {
            throw new IllegalArgumentException(String.format("illegal error code [%d], must be >= 400 and < 600", errorCode));
        }
        this.errorCode = errorCode;
        this.tenant = tenant;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getTenant() {
        return this.tenant;
    }

    private static String providedOrDefaultMessage(int errorCode, String msg) {
        if (msg != null) {
            return msg;
        }
        return "Error Code: " + errorCode;
    }

    public static int extractStatusCode(Throwable t) {
        return Optional.ofNullable(t).map(cause -> {
            if (cause instanceof ServiceInvocationException) {
                return ((ServiceInvocationException)cause).getErrorCode();
            }
            return 500;
        }).orElse(500);
    }

    public static String getLocalizedMessage(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOG.debug("resource not found: {}", (Object)key);
            return key;
        }
    }

    public static String getErrorMessageForExternalClient(Throwable t) {
        if (t instanceof ServerErrorException) {
            ServerErrorException serverError = (ServerErrorException)t;
            String clientFacingMessage = serverError.getClientFacingMessage();
            if (clientFacingMessage != null) {
                return clientFacingMessage;
            }
            switch (serverError.getErrorCode()) {
                case 500: {
                    return "Internal server error";
                }
                case 503: {
                    return "Temporarily unavailable";
                }
            }
        }
        return Optional.ofNullable(t).map(Throwable::getMessage).orElse(null);
    }

    static {
        BUNDLE_NAME = ServiceInvocationException.class.getName() + "_messages";
        resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    }
}

