/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.events.v1.Event;
import io.fabric8.kubernetes.api.model.events.v1.EventFluent;
import io.fabric8.kubernetes.api.model.events.v1.EventFluentImpl;

public class EventBuilder
extends EventFluentImpl<EventBuilder>
implements VisitableBuilder<Event, EventBuilder> {
    EventFluent<?> fluent;
    Boolean validationEnabled;

    public EventBuilder() {
        this(false);
    }

    public EventBuilder(Boolean validationEnabled) {
        this(new Event(), validationEnabled);
    }

    public EventBuilder(EventFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EventBuilder(EventFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Event(), validationEnabled);
    }

    public EventBuilder(EventFluent<?> fluent, Event instance) {
        this(fluent, instance, false);
    }

    public EventBuilder(EventFluent<?> fluent, Event instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withAction(instance.getAction());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withDeprecatedCount(instance.getDeprecatedCount());
            fluent.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
            fluent.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
            fluent.withDeprecatedSource(instance.getDeprecatedSource());
            fluent.withEventTime(instance.getEventTime());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withNote(instance.getNote());
            fluent.withReason(instance.getReason());
            fluent.withRegarding(instance.getRegarding());
            fluent.withRelated(instance.getRelated());
            fluent.withReportingController(instance.getReportingController());
            fluent.withReportingInstance(instance.getReportingInstance());
            fluent.withSeries(instance.getSeries());
            fluent.withType(instance.getType());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public EventBuilder(Event instance) {
        this(instance, (Boolean)false);
    }

    public EventBuilder(Event instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withApiVersion(instance.getApiVersion());
            this.withDeprecatedCount(instance.getDeprecatedCount());
            this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
            this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
            this.withDeprecatedSource(instance.getDeprecatedSource());
            this.withEventTime(instance.getEventTime());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNote(instance.getNote());
            this.withReason(instance.getReason());
            this.withRegarding(instance.getRegarding());
            this.withRelated(instance.getRelated());
            this.withReportingController(instance.getReportingController());
            this.withReportingInstance(instance.getReportingInstance());
            this.withSeries(instance.getSeries());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Event build() {
        Event buildable = new Event(this.fluent.getAction(), this.fluent.getApiVersion(), this.fluent.getDeprecatedCount(), this.fluent.getDeprecatedFirstTimestamp(), this.fluent.getDeprecatedLastTimestamp(), this.fluent.getDeprecatedSource(), this.fluent.getEventTime(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getNote(), this.fluent.getReason(), this.fluent.getRegarding(), this.fluent.getRelated(), this.fluent.getReportingController(), this.fluent.getReportingInstance(), this.fluent.getSeries(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

