/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.vertx.VertxHttpRequest;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

class InputStreamReadStream
implements ReadStream<Buffer> {
    private static final int CHUNK_SIZE = 2048;
    private static final int MAX_DEPTH = 8;
    private final Buffer endSentinel;
    private final VertxHttpRequest vertxHttpRequest;
    private final InputStream is;
    private final HttpClientRequest request;
    private InboundBuffer<Buffer> inboundBuffer;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private byte[] bytes;
    final ThreadLocal<AtomicInteger> counter = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };

    public InputStreamReadStream(VertxHttpRequest vertxHttpRequest, InputStream is, HttpClientRequest request) {
        this.vertxHttpRequest = vertxHttpRequest;
        this.is = is;
        this.request = request;
        this.endSentinel = Buffer.buffer();
    }

    @Override
    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        boolean start;
        boolean bl = start = this.inboundBuffer == null && handler != null;
        if (start) {
            this.inboundBuffer = new InboundBuffer(this.vertxHttpRequest.vertx.getOrCreateContext());
            this.inboundBuffer.drainHandler(v -> this.readChunk());
        }
        if (handler != null) {
            this.inboundBuffer.handler((E buff) -> {
                if (buff == this.endSentinel) {
                    if (this.endHandler != null) {
                        this.endHandler.handle(null);
                    }
                } else {
                    handler.handle((Buffer)buff);
                }
            });
        } else {
            this.inboundBuffer.handler(null);
        }
        if (start) {
            this.readChunk();
        }
        return this;
    }

    private void readChunk() {
        AtomicInteger atomicInteger = this.counter.get();
        try {
            int depth = atomicInteger.getAndIncrement();
            if (depth < 8) {
                this.readChunk2();
                return;
            }
        }
        finally {
            atomicInteger.decrementAndGet();
        }
        this.vertxHttpRequest.vertx.runOnContext(v -> this.readChunk());
    }

    private void readChunk2() {
        Future fut = this.vertxHttpRequest.vertx.executeBlocking(p -> {
            int amount;
            if (this.bytes == null) {
                this.bytes = new byte[2048];
            }
            try {
                amount = this.is.read(this.bytes);
            }
            catch (IOException e) {
                p.fail(e);
                return;
            }
            if (amount == -1) {
                p.complete();
            } else {
                p.complete(Buffer.buffer(VertxByteBufAllocator.DEFAULT.heapBuffer(amount, Integer.MAX_VALUE).writeBytes(this.bytes, 0, amount)));
            }
        });
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                Buffer chunk = (Buffer)ar.result();
                if (chunk != null) {
                    boolean writable = this.inboundBuffer.write(chunk);
                    if (writable) {
                        this.readChunk();
                    }
                } else {
                    this.inboundBuffer.write(this.endSentinel);
                }
            } else {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle(ar.cause());
                }
                this.request.reset(0L, ar.cause());
            }
        });
    }

    @Override
    public ReadStream<Buffer> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public ReadStream<Buffer> pause() {
        this.inboundBuffer.pause();
        return this;
    }

    @Override
    public ReadStream<Buffer> resume() {
        this.inboundBuffer.resume();
        return this;
    }

    @Override
    public ReadStream<Buffer> fetch(long amount) {
        this.inboundBuffer.fetch(amount);
        return this;
    }
}

