/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.launcher.QuarkusLauncher;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.SnapStartRecorder;
import io.quarkus.runtime.logging.JBossVersion;
import io.quarkus.runtime.shutdown.ShutdownRecorder;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class Quarkus {
    private static Closeable LAUNCHED_FROM_IDE;
    private static Application manualApp;
    private static final int MANUAL_BEGIN = 0;
    private static final int MANUAL_BEGIN_INITIALIZATION = 1;
    private static final int MANUAL_INITIALIZED = 2;
    private static final int MANUAL_STARTING = 5;
    private static final int MANUAL_STARTED = 6;
    private static final int MANUAL_FAILURE = 7;
    private static volatile int manualState;
    private static final Object manualLock;

    public static void run(Class<? extends QuarkusApplication> quarkusApplication, String ... args) {
        Quarkus.run(quarkusApplication, null, args);
    }

    public static void run(Class<? extends QuarkusApplication> quarkusApplication, BiConsumer<Integer, Throwable> exitHandler, String ... args) {
        try {
            JBossVersion.disableVersionLogging();
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", "io.quarkus.bootstrap.forkjoin.QuarkusForkJoinWorkerThreadFactory");
            Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl", false, Thread.currentThread().getContextClassLoader());
            Application application = (Application)appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ApplicationLifecycleManager.run(application, quarkusApplication, exitHandler, args);
            return;
        }
        catch (ClassNotFoundException appClass) {
        }
        catch (Exception e) {
            if (exitHandler != null) {
                exitHandler.accept(1, e);
            } else {
                Logger.getLogger(Quarkus.class).error((Object)"Error running Quarkus", e);
                ApplicationLifecycleManager.getDefaultExitCodeHandler().accept(1, e);
            }
            return;
        }
        Quarkus.launchFromIDE(quarkusApplication, args);
    }

    private static void launchFromIDE(Class<? extends QuarkusApplication> quarkusApplication, String ... args) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int pos = 2;
        while (stackTrace[pos].getClassName().equals(Quarkus.class.getName())) {
            ++pos;
        }
        String callingClass = stackTrace[pos].getClassName();
        LAUNCHED_FROM_IDE = QuarkusLauncher.launch((String)callingClass, (String)(quarkusApplication == null ? null : quarkusApplication.getName()), (String[])args);
    }

    private static void terminateForIDE() {
        if (LAUNCHED_FROM_IDE != null) {
            try {
                LAUNCHED_FROM_IDE.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void run(String ... args) {
        Quarkus.run(null, args);
    }

    public static void asyncExit(int code) {
        Quarkus.terminateForIDE();
        ApplicationLifecycleManager.exit(code);
    }

    public static void asyncExit() {
        Quarkus.terminateForIDE();
        ApplicationLifecycleManager.exit(-1);
    }

    public static void waitForExit() {
        ApplicationLifecycleManager.waitForExit();
    }

    public static void blockingExit() {
        if (Quarkus.isMainThread(Thread.currentThread())) {
            Logger.getLogger(Quarkus.class).error("'Quarkus#blockingExit' was called on the main thread. This will result in deadlocking the application!");
        }
        Application app = Application.currentApplication();
        Quarkus.asyncExit();
        if (app != null) {
            app.awaitShutdown();
        }
    }

    public static boolean isMainThread(Thread thread) {
        return thread.getThreadGroup().getName().equals("main") && thread.getName().toLowerCase(Locale.ROOT).contains("main");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void manualInitialize() {
        int tmpState = manualState;
        if (tmpState == 7) {
            throw new RuntimeException("Quarkus manual bootstrap failed");
        }
        if (tmpState > 0) {
            return;
        }
        Object object = manualLock;
        synchronized (object) {
            tmpState = manualState;
            if (tmpState == 7) {
                throw new RuntimeException("Quarkus manual bootstrap failed");
            }
            if (tmpState > 0) {
                return;
            }
            manualState = 1;
        }
        try {
            Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl");
            manualApp = (Application)appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            manualState = 2;
            if (SnapStartRecorder.enabled && SnapStartRecorder.fullWarmup) {
                Quarkus.manualStart();
            }
        }
        catch (Exception e) {
            manualState = 7;
            throw new RuntimeException("Quarkus manual initialization failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void manualStart() {
        int tmpState = manualState;
        if (tmpState == 7) {
            throw new IllegalStateException("Quarkus failed to start up");
        }
        if (tmpState >= 5) {
            return;
        }
        Object object = manualLock;
        synchronized (object) {
            tmpState = manualState;
            if (tmpState == 7) {
                throw new RuntimeException("Quarkus manual bootstrap failed");
            }
            if (tmpState >= 5) {
                return;
            }
            if (tmpState != 2) {
                throw new IllegalStateException("Quarkus manual start cannot proceed as warmup did not run");
            }
            manualState = 5;
        }
        try {
            String[] args = new String[]{};
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ShutdownRecorder.runShutdown();
                    manualApp.doStop();
                }
            });
            manualApp.doStart(args);
        }
        catch (RuntimeException e) {
            manualState = 7;
            throw e;
        }
        manualState = 6;
    }

    static {
        manualState = 0;
        manualLock = new Object();
    }
}

