/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.net.HostAndPort;

public class HostAndPortImpl
implements HostAndPort {
    private final String host;
    private final int port;

    static int parseHost(String val, int from, int to) {
        int pos = HostAndPortImpl.parseIPLiteral(val, from, to);
        if (pos != -1) {
            return pos;
        }
        pos = HostAndPortImpl.parseIPv4Address(val, from, to);
        if (pos != -1) {
            return pos;
        }
        pos = HostAndPortImpl.parseRegName(val, from, to);
        if (pos != -1) {
            return pos;
        }
        return -1;
    }

    private static int foo(int v) {
        return v == -1 ? -1 : v + 1;
    }

    static int parseIPv4Address(String s, int from, int to) {
        for (int i = 0; i < 4; ++i) {
            if (i > 0 && from < to && s.charAt(from++) != '.') {
                return -1;
            }
            if ((from = HostAndPortImpl.parseDecOctet(s, from, to)) != -1) continue;
            return -1;
        }
        return from;
    }

    static int parseDecOctet(String s, int from, int to) {
        int val = HostAndPortImpl.parseDigit(s, from++, to);
        switch (val) {
            case 0: {
                return from;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int n = HostAndPortImpl.parseDigit(s, from, to);
                if (n != -1) {
                    val = val * 10 + n;
                    if ((n = HostAndPortImpl.parseDigit(s, ++from, to)) != -1) {
                        ++from;
                        val = val * 10 + n;
                    }
                }
                if (val >= 256) break;
                return from;
            }
        }
        return -1;
    }

    private static int parseDigit(String s, int from, int to) {
        char c;
        return from < to && HostAndPortImpl.isDIGIT(c = s.charAt(from)) ? c - 48 : -1;
    }

    public static int parseIPLiteral(String s, int from, int to) {
        return from + 2 < to && s.charAt(from) == '[' ? HostAndPortImpl.foo(s.indexOf(93, from + 2)) : -1;
    }

    public static int parseRegName(String s, int from, int to) {
        while (from < to) {
            char c = s.charAt(from);
            if (HostAndPortImpl.isUnreserved(c) || HostAndPortImpl.isSubDelims(c)) {
                ++from;
                continue;
            }
            if (c != '%' || from + 2 >= to || !HostAndPortImpl.isHEXDIG(s.charAt(c + '\u0001')) || !HostAndPortImpl.isHEXDIG(s.charAt(c + 2))) break;
            from += 3;
        }
        return from;
    }

    private static boolean isUnreserved(char ch) {
        return HostAndPortImpl.isALPHA(ch) || HostAndPortImpl.isDIGIT(ch) || ch == '-' || ch == '.' || ch == '_' || ch == '~';
    }

    private static boolean isALPHA(char ch) {
        return 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z';
    }

    private static boolean isDIGIT(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static boolean isSubDelims(char ch) {
        return ch == '!' || ch == '$' || ch == '&' || ch == '\'' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == ',' || ch == ';' || ch == '=';
    }

    static boolean isHEXDIG(char ch) {
        return HostAndPortImpl.isDIGIT(ch) || 'A' <= ch && ch <= 'F' || 'a' <= ch && ch <= 'f';
    }

    public static HostAndPortImpl parseHostAndPort(String s, int schemePort) {
        int pos = HostAndPortImpl.parseHost(s, 0, s.length());
        if (pos == s.length()) {
            return new HostAndPortImpl(s, schemePort);
        }
        if (pos < s.length() && s.charAt(pos) == ':') {
            String host = s.substring(0, pos);
            int port = 0;
            while (++pos < s.length()) {
                int digit = HostAndPortImpl.parseDigit(s, pos, s.length());
                if (digit == -1) {
                    return null;
                }
                port = port * 10 + digit;
            }
            return new HostAndPortImpl(host, port);
        }
        return null;
    }

    public HostAndPortImpl(String host, int port) {
        if (host == null) {
            throw new NullPointerException();
        }
        this.host = host;
        this.port = port;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    public String toString() {
        if (this.port >= 0) {
            return this.host + ':' + this.port;
        }
        return this.host;
    }
}

