/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime.context;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.vertx.SafeVertxContext;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import org.jboss.logging.Logger;

@SafeVertxContext
@Priority(value=0)
@Interceptor
public class SafeVertxContextInterceptor {
    @Inject
    Vertx vertx;
    private static final Logger LOGGER = Logger.getLogger(SafeVertxContextInterceptor.class);

    @AroundInvoke
    public Object markTheContextSafe(ArcInvocationContext ic) throws Exception {
        Context current = this.vertx.getOrCreateContext();
        if (VertxContextSafetyToggle.isExplicitlyMarkedAsSafe(current)) {
            return ic.proceed();
        }
        SafeVertxContext annotation = ic.findIterceptorBinding(SafeVertxContext.class);
        boolean unsafe = VertxContextSafetyToggle.isExplicitlyMarkedAsUnsafe(current);
        if (unsafe && annotation.force()) {
            LOGGER.debugf("Force the duplicated context as `safe` while is was explicitly marked as `unsafe` in %s.%s", (Object)ic.getMethod().getDeclaringClass().getName(), (Object)ic.getMethod().getName());
        } else if (unsafe) {
            throw new IllegalStateException("Unable to mark the context as safe, as the current context is explicitly marked as unsafe");
        }
        VertxContextSafetyToggle.setContextSafe(current, true);
        return ic.proceed();
    }
}

