/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class QueueHandler
extends ExtHandler {
    private final Deque<ExtLogRecord> buffer = new ArrayDeque<ExtLogRecord>();
    private int limit = 10;

    public QueueHandler() {
    }

    public QueueHandler(int limit) {
        if (limit < 1) {
            throw QueueHandler.badQueueLength();
        }
        this.limit = limit;
    }

    @Override
    public void publish(ExtLogRecord record) {
        if (this.isEnabled() && record != null) {
            this.doPublish(record);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isEnabled() && record != null) {
            this.doPublish(ExtLogRecord.wrap(record));
        }
    }

    @Override
    protected void doPublish(ExtLogRecord record) {
        this.lock.lock();
        try {
            if (this.isLoggable(record)) {
                if (this.isCallerCalculationRequired()) {
                    record.copyAll();
                } else {
                    record.disableCallerCalculation();
                    record.copyMdc();
                }
                if (this.buffer.size() == this.limit) {
                    this.buffer.removeFirst();
                }
                this.buffer.addLast(record);
            }
            this.publishToNestedHandlers(record);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getLimit() {
        this.lock.lock();
        try {
            int n = this.limit;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLimit(int limit) {
        if (limit < 1) {
            throw QueueHandler.badQueueLength();
        }
        this.lock.lock();
        try {
            this.limit = limit;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        this.addHandler(handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler, boolean replay) throws SecurityException {
        Assert.checkNotNullParam("handler", handler);
        if (replay) {
            this.lock.lock();
            try {
                super.addHandler(handler);
                for (ExtLogRecord record : this.buffer) {
                    handler.publish(record);
                }
            }
            finally {
                this.lock.unlock();
            }
        } else {
            super.addHandler(handler);
        }
    }

    public ExtLogRecord[] getQueue() {
        this.lock.lock();
        try {
            ExtLogRecord[] extLogRecordArray = (ExtLogRecord[])this.buffer.toArray(ExtLogRecord[]::new);
            return extLogRecordArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String[] getQueueAsStrings() {
        ExtLogRecord[] queue = this.getQueue();
        int length = queue.length;
        String[] strings = new String[length];
        Formatter formatter = this.getFormatter();
        int i = 0;
        for (int j = 0; j < length; ++j) {
            try {
                String formatted = formatter.format(queue[j]);
                if (formatted.length() <= 0) continue;
                strings[i++] = this.getFormatter().format(queue[j]);
                continue;
            }
            catch (Exception ex) {
                this.reportError("Formatting error", ex, 5);
            }
        }
        return strings;
    }

    public void replay() {
        Handler[] handlers = this.getHandlers();
        if (handlers.length > 0) {
            for (ExtLogRecord record : this.getQueue()) {
                for (Handler handler : handlers) {
                    handler.publish(record);
                }
            }
        }
    }

    private static IllegalArgumentException badQueueLength() {
        return new IllegalArgumentException("Queue length must be at least 1");
    }
}

