/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.repository;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryCreator;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryRegistry;

public class IntentProjectBasedRepositoryManagerContribution
implements IntentRepositoryManagerContribution {
    public boolean canCreateRepository(String identifier) {
        return !identifier.contains("/");
    }

    public Repository createRepository(String identifier) throws RepositoryConnectionException {
        Repository repository = null;
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(identifier);
            if (project != null && project.exists() && project.isAccessible()) {
                if (!project.isOpen()) {
                    project.open(null);
                }
                if (project.hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) {
                    String repositoryType = IntentProjectBasedRepositoryManagerContribution.getRepositoryType(project);
                    RepositoryCreator repositoryCreator = RepositoryRegistry.INSTANCE.getRepositoryCreator(repositoryType);
                    RepositoryStructurer repositoryStructurer = RepositoryRegistry.INSTANCE.getRepositoryStructurer(repositoryType);
                    if (repositoryCreator == null) {
                        throw new RepositoryConnectionException("Cannot instantiate a repository of type:" + repositoryType);
                    }
                    repository = repositoryCreator.createRepository((Object)project, repositoryStructurer);
                }
            }
        }
        catch (CoreException e) {
            throw new RepositoryConnectionException(e.getMessage());
        }
        return repository;
    }

    private static String getRepositoryType(IProject project) throws CoreException {
        ICommand[] iCommandArray = project.getDescription().getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals("org.eclipse.mylyn.docs.intent.client.ui.ide.intentBuilder")) {
                return (String)command.getArguments().get("type");
            }
            ++n2;
        }
        return null;
    }
}

