/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.cdo.repository;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mylyn.docs.intent.collab.cdo.adapters.CDOAdapter;
import org.eclipse.mylyn.docs.intent.collab.cdo.repository.CDOConfig;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;

public class CDORepository
implements Repository {
    private static IConnector connector;
    private static IManagedContainer container;
    private static CDONet4jSessionConfiguration cdoSessionConfiguration;
    private static CDONet4jSession session;
    private static Set<CDORepository> activeRepositories;
    private CDOConfig repositoryConfiguration;
    private Set<RepositoryClient> clientRegistry;

    static {
        activeRepositories = new LinkedHashSet<CDORepository>();
    }

    public CDORepository(CDOConfig configuration) {
        this.repositoryConfiguration = configuration;
        this.clientRegistry = new LinkedHashSet<RepositoryClient>();
    }

    public void register(RepositoryClient client) {
        this.clientRegistry.add(client);
    }

    public void unregister(RepositoryClient client) {
        this.clientRegistry.remove(client);
        if (this.clientRegistry.isEmpty()) {
            this.closeSession();
        }
    }

    public Object getOrCreateSession() throws RepositoryConnectionException {
        if (cdoSessionConfiguration == null) {
            container = ContainerUtil.createContainer();
            Net4jUtil.prepareContainer((IManagedContainer)container);
            TCPUtil.prepareContainer((IManagedContainer)container);
            CDONet4jUtil.prepareContainer((IManagedContainer)container);
            container.activate();
            connector = TCPUtil.getConnector((IManagedContainer)container, (String)this.repositoryConfiguration.getServerAdress());
            cdoSessionConfiguration = CDONet4jUtil.createNet4jSessionConfiguration();
            cdoSessionConfiguration.setConnector(connector);
            cdoSessionConfiguration.setRepositoryName(this.repositoryConfiguration.getRepositoryName());
        }
        if (session == null || session.isClosed()) {
            try {
                session = cdoSessionConfiguration.openNet4jSession();
            }
            catch (TimeoutRuntimeException tre) {
                throw new RepositoryConnectionException(tre.getMessage());
            }
            catch (ChannelException ce) {
                throw new RepositoryConnectionException(ce.getMessage());
            }
        }
        if (!activeRepositories.contains(this)) {
            activeRepositories.add(this);
        }
        return session;
    }

    public void closeSession() {
        activeRepositories.remove(this);
        if (activeRepositories.isEmpty() && session != null) {
            session.close();
            session = null;
            connector.close();
            connector = null;
            container.deactivate();
            container = null;
            cdoSessionConfiguration = null;
        }
    }

    public CDOConfig getConfiguration() {
        return this.repositoryConfiguration;
    }

    public EPackage.Registry getPackageRegistry() throws RepositoryConnectionException {
        return ((CDONet4jSession)this.getOrCreateSession()).getPackageRegistry();
    }

    public RepositoryAdapter createRepositoryAdapter() {
        try {
            return new CDOAdapter((CDONet4jSession)this.getOrCreateSession());
        }
        catch (RepositoryConnectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setRepositoryStructurer(RepositoryStructurer structurer) {
    }
}

