/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementListNotificator
implements Notificator {
    private final Set<EObject> listenedObjects;
    private Set<RepositoryObjectHandler> listeningHandlers;
    private final ElementListAdapter elementAdapter;

    public ElementListNotificator(Set<EObject> listenedObjects, RepositoryAdapter repositoryAdapter) {
        this.listenedObjects = listenedObjects;
        this.listeningHandlers = new LinkedHashSet<RepositoryObjectHandler>();
        this.elementAdapter = new ElementListAdapter(this);
        this.initialize(this.listeningHandlers, repositoryAdapter);
    }

    public ElementListNotificator(Set<EObject> listenedObjects, ElementListAdapter listAdapter, RepositoryAdapter repositoryAdapter) {
        this.listenedObjects = listenedObjects;
        this.listeningHandlers = new LinkedHashSet<RepositoryObjectHandler>();
        this.elementAdapter = listAdapter;
        listAdapter.setNotificator(this);
        this.initialize(this.listeningHandlers, repositoryAdapter);
    }

    public void initialize(Set<RepositoryObjectHandler> handlersToRegister, RepositoryAdapter repositoryAdapter) {
        repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                for (EObject objectToListen : ElementListNotificator.this.listenedObjects) {
                    objectToListen.eAdapters().add((Object)ElementListNotificator.this.elementAdapter);
                }
            }
        });
        for (RepositoryObjectHandler listeningHandler : handlersToRegister) {
            this.addRepositoryObjectHandler(listeningHandler);
        }
    }

    @Override
    public void stop() {
        for (EObject objectToListen : this.listenedObjects) {
            try {
                objectToListen.eAdapters().remove((Object)this.elementAdapter);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalStateException illegalStateException) {}
            this.listeningHandlers.clear();
        }
    }

    @Override
    public void addRepositoryObjectHandler(RepositoryObjectHandler listener) {
        this.listeningHandlers.add(listener);
    }

    @Override
    public void removeRepositoryObjectHandler(RepositoryObjectHandler listener) {
        this.listeningHandlers.remove(listener);
    }

    @Override
    public void notifyHandlers(RepositoryChangeNotification changeNotification) {
        for (RepositoryObjectHandler handler : this.listeningHandlers) {
            handler.handleChangeNotification(changeNotification);
        }
    }

    @Override
    public void addObjectsToListen(List<EObject> objectsToHandle) {
        for (EObject objectToListen : objectsToHandle) {
            if (this.listenedObjects.contains(objectToListen)) continue;
            objectToListen.eAdapters().add((Object)this.elementAdapter);
            this.listenedObjects.add(objectToListen);
        }
    }

    @Override
    public void removeObjectsToListen(List<Object> objectsToRemove) {
        for (Object objectToRemove : objectsToRemove) {
            if (!(objectToRemove instanceof EObject)) continue;
            EObject eObjectToRemove = (EObject)objectToRemove;
            try {
                eObjectToRemove.eAdapters().remove((Object)this.elementAdapter);
                this.listenedObjects.remove(eObjectToRemove);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }
}

