/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;

public class CreateResourceFix
extends AbstractIntentFix {
    public CreateResourceFix(IntentAnnotation annotation) {
        super(annotation);
    }

    protected void applyFix(RepositoryAdapter repositoryAdapter, IntentEditorDocument document) {
        String workingCopyResourceURI = this.getWorkingCopyResourceURI();
        String compiledResourceURI = ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getCompiledResourceURI();
        if (compiledResourceURI != null) {
            compiledResourceURI = compiledResourceURI.replace("\"", "");
            Resource generatedResource = repositoryAdapter.getResource(compiledResourceURI);
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource workingCopyResource = rs.createResource(URI.createURI((String)workingCopyResourceURI));
            workingCopyResource.getContents().addAll(EcoreUtil.copyAll((Collection)generatedResource.getContents()));
            try {
                workingCopyResource.save(null);
            }
            catch (IOException e) {
                IntentUiLogger.logError(e);
            }
        } else {
            IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Invalid URI : cannot create resource at " + workingCopyResourceURI);
        }
    }

    private String getWorkingCopyResourceURI() {
        return ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getWorkingCopyResourceURI().replace("\"", "");
    }

    public String getDisplayString() {
        return "Create the " + this.getWorkingCopyResourceURI() + " resource, initialized with working copy content";
    }
}

