/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.polling;

import com.ibm.jbatch.tck.spi.JobExecutionTimeoutException;
import com.ibm.jbatch.tck.spi.JobExecutionWaiter;
import com.ibm.jbatch.tck.spi.JobExecutionWaiterFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;

public class TCKPollingExecutionWaiterFactory
implements JobExecutionWaiterFactory {
    private static final String sourceClass = TCKPollingExecutionWaiterFactory.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final int POLL_INTERVAL = 100;
    private static Set<BatchStatus> terminatedStatuses = new HashSet<BatchStatus>();

    public JobExecutionWaiter createWaiter(long executionId, JobOperator jobOp, long timeout) {
        return new TCKPollingExecutionWaiter(executionId, jobOp, timeout);
    }

    static {
        terminatedStatuses.add(BatchStatus.STOPPED);
        terminatedStatuses.add(BatchStatus.FAILED);
        terminatedStatuses.add(BatchStatus.COMPLETED);
        terminatedStatuses.add(BatchStatus.ABANDONED);
    }

    private class TCKPollingExecutionWaiter
    implements JobExecutionWaiter {
        private long executionId;
        private JobOperator jobOp;
        private long timeout;

        private TCKPollingExecutionWaiter(long executionId, JobOperator jobOp, long timeout) {
            logger.fine("Creating waiter for executionId = " + executionId + ", jobOp = " + jobOp + ", timeout = " + timeout);
            this.executionId = executionId;
            this.jobOp = jobOp;
            this.timeout = timeout;
        }

        public JobExecution awaitTermination() throws JobExecutionTimeoutException {
            logger.fine("Entering awaitTermination for executionId = " + this.executionId);
            JobExecution jobExecution = null;
            long startTime = System.currentTimeMillis();
            try {
                do {
                    logger.finer("Sleeping for 100");
                    long curTime = System.currentTimeMillis();
                    this.timeOutIfExpired(startTime, curTime);
                    Thread.sleep(100L);
                    logger.finer("Wake up, check for termination.");
                } while (!this.isTerminated(jobExecution = this.jobOp.getJobExecution(this.executionId)));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Aborting on interrupt", e);
            }
            catch (JobSecurityException e) {
                throw new IllegalStateException("Aborting on security (authorization) exception", e);
            }
            catch (NoSuchJobExecutionException e) {
                throw new IllegalStateException("JobExecution disappeared for exec id =" + this.executionId);
            }
            return jobExecution;
        }

        private boolean isTerminated(JobExecution jobExecution) {
            boolean retVal = false;
            BatchStatus bs = jobExecution.getBatchStatus();
            if (terminatedStatuses.contains(bs)) {
                logger.fine("Found terminating batch status of: " + jobExecution.getBatchStatus().name());
                if (jobExecution.getExitStatus() != null) {
                    logger.fine("Found exit status of: " + jobExecution.getExitStatus());
                    retVal = true;
                } else {
                    logger.fine("Exit status is still 'null'.  Poll again.");
                    retVal = false;
                }
            } else {
                logger.finer("Found non-terminating batch status of: " + jobExecution.getBatchStatus().name());
                retVal = false;
            }
            return retVal;
        }

        private void timeOutIfExpired(long startTime, long curTime) {
            long diff = curTime - startTime;
            if (diff > this.timeout) {
                logger.warning("Timed out waiting for TCK Job Execution to reach terminated status.  Time elapsed (long msec) = " + diff + ", and timeout = " + this.timeout);
                throw new IllegalStateException("Timed out waiting for TCK Job Execution to reach terminated status.  Time elapsed (long msec) = " + diff + ", and timeout = " + this.timeout);
            }
            logger.finer("Still waiting for TCK Job Execution to reach terminated status.  Time elapsed (long msec) = " + diff + ", and timeout = " + this.timeout);
        }
    }
}

