/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.basicchunk.BasicItem;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemReader;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;

@Named(value="PUDPartitionReader")
public class PUDPartitionReader
extends AbstractItemReader {
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="partition.number")
    String partitionNumber;
    @Inject
    @BatchProperty(name="execution.number")
    String executionNumber;
    @Inject
    @BatchProperty(name="number.of.items.to.be.read")
    String injectedNumberOfItemsToBeRead;
    private int numberOfItemsToBeRead = 10;
    @Inject
    @BatchProperty(name="throw.reader.exception.for.these.items")
    String injectedThrowReaderExceptionForTheseItems;
    private int[] throwReaderExceptionForTheseItems = new int[0];
    private String PUDString;
    private int currentItemId = -1;
    private BasicItem currentItem = null;

    public void open(Serializable checkpoint) {
        this.PUDString = "PUD for Partition: " + this.partitionNumber;
        if (checkpoint == null) {
            this.stepCtx.setPersistentUserData((Serializable)((Object)this.PUDString));
        }
        if (this.injectedNumberOfItemsToBeRead != null) {
            this.numberOfItemsToBeRead = Integer.parseInt(this.injectedNumberOfItemsToBeRead);
        }
        if (this.injectedThrowReaderExceptionForTheseItems != null) {
            String[] exceptionsStringArray = this.injectedThrowReaderExceptionForTheseItems.split(",");
            this.throwReaderExceptionForTheseItems = new int[exceptionsStringArray.length];
            for (int i = 0; i < exceptionsStringArray.length; ++i) {
                this.throwReaderExceptionForTheseItems[i] = Integer.parseInt(exceptionsStringArray[i]);
            }
        }
    }

    public BasicItem readItem() throws Exception {
        if (this.executionNumber.equals("2") && !this.stepCtx.getPersistentUserData().equals(this.PUDString)) {
            throw new Exception("BadPersistentUserData: PUD for partition " + this.partitionNumber + " is expected to be " + this.PUDString + ", but found " + this.stepCtx.getPersistentUserData());
        }
        ++this.currentItemId;
        if (this.currentItemId < this.numberOfItemsToBeRead) {
            this.currentItem = new BasicItem(this.currentItemId);
            if (this.readerExceptionShouldBeThrownForCurrentItem()) {
                this.jobCtx.setExitStatus("Exception:Item#" + this.currentItem.getId());
                throw new Exception("Exception thrown for item " + this.currentItem.getId());
            }
            this.currentItem.setRead(true);
            return this.currentItem;
        }
        return null;
    }

    private boolean readerExceptionShouldBeThrownForCurrentItem() {
        for (int i : this.throwReaderExceptionForTheseItems) {
            if (this.currentItem.getId() != i) continue;
            return true;
        }
        return false;
    }
}

