/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.logging.Logger;

@Named(value="skipProcessor")
public class SkipProcessor
implements ItemProcessor {
    private static final Logger logger = Logger.getLogger(SkipProcessor.class.getName());
    @Inject
    @BatchProperty(name="execution.number")
    String executionNumberString;
    @Inject
    @BatchProperty(name="processrecord.fail")
    String processrecordfailNumberString = null;
    boolean init = true;
    boolean threwSkipException = false;
    private int update = 10;
    int[] failnum;
    int execnum;
    boolean inited = false;
    int processIteration = 0;

    public ReadRecord processItem(Object record) throws Exception {
        if (!this.inited) {
            if (this.processrecordfailNumberString != null) {
                String[] processFailPointsStrArr = this.processrecordfailNumberString.split(",");
                this.failnum = new int[processFailPointsStrArr.length];
                for (int i = 0; i < processFailPointsStrArr.length; ++i) {
                    this.failnum[i] = Integer.parseInt(processFailPointsStrArr[i]);
                }
            } else {
                this.failnum = new int[1];
                this.failnum[0] = -1;
            }
            this.inited = true;
            logger.fine("AJM: PROCESSOR - failnum = " + this.failnum);
        }
        if (this.threwSkipException) {
            ++this.update;
            ++this.processIteration;
            this.threwSkipException = false;
        }
        logger.fine("AJM: PROCESSOR: failnum = " + this.failnum);
        logger.fine("AJM: PROCESSOR: processIteration = " + this.processIteration);
        ReadRecord processedRecord = null;
        if (this.isFailnum(this.processIteration)) {
            logger.fine("READ: got the fail num..." + this.failnum);
            this.threwSkipException = true;
            throw new MyParentException("fail on purpose on idx = " + this.failnum);
        }
        processedRecord = (ReadRecord)record;
        processedRecord.setRecord(this.update);
        ++this.update;
        ++this.processIteration;
        return processedRecord;
    }

    private boolean isFailnum(int idxIn) {
        boolean ans = false;
        for (int i = 0; i < this.failnum.length; ++i) {
            if (idxIn != this.failnum[i]) continue;
            ans = true;
        }
        return ans;
    }
}

