/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JobLevelPropertiesTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;
    private String FOO_VALUE = "bar";

    @Test
    public void testJobLevelPropertiesCount() throws Exception {
        String METHOD = "testJobLevelPropertiesCount";
        String SHOULD_BE_UNAVAILABLE_PROP_PREFIX = "com.ibm.jbatch.tck.tests.jslxml.JobLevelPropertiesTests";
        Properties jobParams = new Properties();
        jobParams.put(SHOULD_BE_UNAVAILABLE_PROP_PREFIX + ".parm1", "should.not.appear.in.job.context.properties");
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_level_properties_count", jobParams);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Job completed", "VERY GOOD INVOCATION", jobExec.getExitStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            JobLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testJobLevelPropertiesPropertyValue() throws Exception {
        String METHOD = "testJobLevelPropertiesPropertyValue";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_level_properties_value");
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
            AssertionUtils.assertWithMessage("Property value", this.FOO_VALUE, jobExec.getExitStatus());
            Reporter.log((String)("Job batchlet return code is the job property foo value " + this.FOO_VALUE));
        }
        catch (Exception e) {
            JobLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testJobLevelPropertiesShouldNotBeAvailableThroughStepContext() throws Exception {
        String METHOD = "testJobLevelPropertiesShouldNotBeAvailableThroughStepContext";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_level_properties_scope");
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
            AssertionUtils.assertWithMessage("Job Level Property is not available through step context", BatchStatus.COMPLETED.name(), jobExec.getExitStatus());
            Reporter.log((String)("Job batchlet return code is the job.property read through step context (expected value=COMPLETED) " + jobExec.getExitStatus()));
        }
        catch (Exception e) {
            JobLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

