/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.test.spi.ArquillianProxyException;

public class ExceptionProxy
implements Externalizable {
    private static final long serialVersionUID = 2321010311438950147L;
    private String className;
    private String message;
    private StackTraceElement[] trace;
    private ExceptionProxy causeProxy;
    private Throwable cause;
    private Throwable original;
    private Throwable serializationProcessException = null;
    private Version version = new Version();
    private List<String> exceptionHierarchy;

    public ExceptionProxy() {
    }

    public ExceptionProxy(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.trace = throwable.getStackTrace();
        this.original = throwable;
        this.exceptionHierarchy = this.getExceptionHierarchy(throwable);
    }

    public static ExceptionProxy createForException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return new ExceptionProxy(throwable);
    }

    public boolean hasException() {
        return this.className != null;
    }

    public Throwable createException() {
        if (!this.hasException()) {
            return null;
        }
        if (this.original != null) {
            return this.original;
        }
        ArquillianProxyException throwable = this.createProxyException("Original exception caused: " + (this.serializationProcessException != null ? this.serializationProcessException.getClass() + ": " + this.serializationProcessException.getMessage() : "Unknown serialization issue"));
        return throwable;
    }

    public ArquillianProxyException createProxyException(String reason) {
        ArquillianProxyException exception = new ArquillianProxyException(this.message, this.className, reason, this.getCause());
        exception.setStackTrace(this.trace);
        return exception;
    }

    public Throwable getCause() {
        if (this.cause == null && this.causeProxy != null) {
            this.cause = this.causeProxy.createException();
        }
        return this.serializationProcessException;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceElement[] getTrace() {
        return this.trace;
    }

    public ExceptionProxy getCauseProxy() {
        return this.causeProxy;
    }

    public Throwable getOriginal() {
        return this.original;
    }

    public Throwable getSerializationProcessException() {
        return this.serializationProcessException;
    }

    public Version getVersion() {
        return this.version;
    }

    public List<String> getExceptionHierarchy() {
        return this.exceptionHierarchy;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("ExceptionProxy(" + this.className + ")");
        if (this.message != null) {
            tmp.append("msg: ").append(this.message);
        }
        if (this.causeProxy != null) {
            tmp.append("\ncause: ").append(this.causeProxy);
        }
        if (this.trace != null) {
            for (StackTraceElement element : this.trace) {
                tmp.append("\n\tat ").append(element);
            }
        }
        if (this.exceptionHierarchy != null) {
            tmp.append("\nexceptionHierarchy: ");
            for (String t : this.exceptionHierarchy) {
                tmp.append("\n\t").append(t);
            }
        }
        if (this.serializationProcessException != null) {
            tmp.append("\nserializationProcessException: ").append(this.serializationProcessException);
        }
        return tmp.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object firstObject = in.readObject();
        if (firstObject instanceof Version) {
            this.version = (Version)firstObject;
            this.className = (String)in.readObject();
            this.message = (String)in.readObject();
            this.trace = (StackTraceElement[])in.readObject();
            this.exceptionHierarchy = (List)in.readObject();
            try {
                byte[] originalExceptionData = (byte[])in.readObject();
                if (originalExceptionData != null && originalExceptionData.length > 0) {
                    ByteArrayInputStream originalIn = new ByteArrayInputStream(originalExceptionData);
                    ObjectInputStream input = new ObjectInputStream(originalIn);
                    this.original = (Throwable)input.readObject();
                }
            }
            catch (Throwable e) {
                this.serializationProcessException = e;
            }
            Throwable tmpSerializationProcessException = (Throwable)in.readObject();
            if (tmpSerializationProcessException != null) {
                this.serializationProcessException = tmpSerializationProcessException;
            }
            if (this.original == null) {
                this.original = this.buildOriginalException();
            }
        } else {
            this.serializationProcessException = new IOException("Unknown version of ExceptionProxy");
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.version);
        out.writeObject(this.className);
        out.writeObject(this.message);
        out.writeObject(this.trace);
        out.writeObject(this.exceptionHierarchy);
        byte[] originalBytes = new byte[]{};
        try {
            ByteArrayOutputStream originalOut = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(originalOut);
            output.writeObject(this.original);
            output.flush();
            originalBytes = originalOut.toByteArray();
        }
        catch (NotSerializableException e) {
            this.serializationProcessException = e;
        }
        out.writeObject(originalBytes);
        out.writeObject(this.serializationProcessException);
    }

    protected List<String> getExceptionHierarchy(Throwable t) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        Class<?> tclass = t.getClass();
        while (Throwable.class.isAssignableFrom(tclass)) {
            hierarchy.add(tclass.getName());
            tclass = tclass.getSuperclass();
        }
        return hierarchy;
    }

    protected Throwable buildOriginalException() {
        Throwable original = null;
        for (String tclassName : this.exceptionHierarchy) {
            try {
                Class<Throwable> tclass = Class.forName(tclassName).asSubclass(Throwable.class);
                try {
                    original = tclass.getDeclaredConstructor(String.class).newInstance(this.message);
                    original.setStackTrace(this.trace);
                    break;
                }
                catch (Exception e) {
                    try {
                        original = tclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        original.setStackTrace(this.trace);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return original;
    }

    public static class Version
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int version = 2;
    }
}

