/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.description;

import java.util.Arrays;
import java.util.Objects;
import org.assertj.core.description.Description;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public class TextDescription
extends Description {
    @VisibleForTesting
    final String value;
    final Object[] args;

    public TextDescription(String value, Object ... args) {
        this.value = value == null ? "" : value;
        this.args = org.assertj.core.util.Arrays.isNullOrEmpty(args) ? null : (Object[])args.clone();
    }

    @Override
    public String value() {
        return Strings.formatIfArgs(this.value, this.args);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.args);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextDescription other = (TextDescription)obj;
        return Objects.deepEquals(this.value, other.value) && Arrays.deepEquals(this.args, other.args);
    }
}

