/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import jakarta.validation.GroupSequence;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ContainerElementConstraintGroupValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ContainerElementConstraintGroupValidationTest.webArchiveBuilder().withTestClass(ContainerElementConstraintGroupValidationTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="e")
    public void sameGroupValidationRulesAppliesOnContainerElementConstraints() {
        Set constraintViolations = this.getValidator().validate((Object)MovieProduction.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("directors").containerElement("<list element>", true, null, 0, List.class, 0)));
        constraintViolations = this.getValidator().validate((Object)MovieProduction.invalid(), new Class[]{ActorGroup.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("mainActor"), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("actors").containerElement("<list element>", true, null, 0, List.class, 0)));
        constraintViolations = this.getValidator().validate((Object)MovieProduction.invalid(), new Class[]{LocationGroup.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("locations").containerElement("<list element>", true, null, 0, List.class, 0)));
        constraintViolations = this.getValidator().validate((Object)MovieProduction.invalid(), new Class[]{EmployeeGroupSequence.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("mainActor"), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("actors").containerElement("<list element>", true, null, 0, List.class, 0)));
        constraintViolations = this.getValidator().validate((Object)MovieProduction.invalidWithValidActors(), new Class[]{EmployeeGroupSequence.class});
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("executiveProducers").containerElement("<list element>", true, null, 0, List.class, 0)));
    }

    private static class MovieProduction {
        private final List<@NotNull String> directors = new ArrayList<String>();
        @NotNull(groups={ActorGroup.class})
        private String mainActor;
        private final List<@NotNull(groups={ActorGroup.class}) String> actors = new ArrayList<String>();
        private final List<@NotNull(groups={ExecutiveProducerGroup.class}) String> executiveProducers = new ArrayList<String>();
        private final List<@NotNull(groups={LocationGroup.class}) String> locations = new ArrayList<String>();

        private MovieProduction() {
        }

        private static MovieProduction invalid() {
            MovieProduction movieProduction = new MovieProduction();
            movieProduction.directors.add(null);
            movieProduction.actors.add(null);
            movieProduction.mainActor = null;
            movieProduction.executiveProducers.add(null);
            movieProduction.locations.add(null);
            return movieProduction;
        }

        private static MovieProduction invalidWithValidActors() {
            MovieProduction movieProduction = new MovieProduction();
            movieProduction.directors.add(null);
            movieProduction.actors.add("Zach Braff");
            movieProduction.mainActor = "Zach Braff";
            movieProduction.executiveProducers.add(null);
            movieProduction.locations.add(null);
            return movieProduction;
        }
    }

    public static interface ActorGroup {
    }

    public static interface LocationGroup {
    }

    @GroupSequence(value={ActorGroup.class, ExecutiveProducerGroup.class})
    public static interface EmployeeGroupSequence {
    }

    public static interface ExecutiveProducerGroup {
    }
}

