/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ContainerElementTypeDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import org.assertj.core.api.Assertions;

class MetaDataTestUtil {
    MetaDataTestUtil() {
    }

    static ContainerElementTypeDescriptor getContainerElementDescriptor(Set<ContainerElementTypeDescriptor> containerElementTypeDescriptors, Class<?> containerClass, int typeArgumentIndex) {
        for (ContainerElementTypeDescriptor containerElementTypeDescriptor : containerElementTypeDescriptors) {
            if (!containerClass.equals(containerElementTypeDescriptor.getContainerClass()) || typeArgumentIndex != containerElementTypeDescriptor.getTypeArgumentIndex()) continue;
            return containerElementTypeDescriptor;
        }
        throw new IllegalStateException(String.format("Container element descriptor not found for container class %1$s and type parameter %2$s", containerClass, typeArgumentIndex));
    }

    @SafeVarargs
    static void assertConstraintDescriptors(Set<ConstraintDescriptor<?>> constraintDescriptors, Class<? extends Annotation> ... expectedConstraints) {
        ArrayList<Class<? extends Annotation>> actualConstraints = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintDescriptor<?> constraintDescriptor : constraintDescriptors) {
            actualConstraints.add(constraintDescriptor.getAnnotation().annotationType());
        }
        Assertions.assertThat(actualConstraints).containsExactlyInAnyOrder((Object[])expectedConstraints);
    }
}

