/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.PlainHttpConnection;
import jdk.incubator.http.internal.common.Utils;

final class ConnectionPool {
    static final long KEEP_ALIVE = Utils.getIntegerNetProperty("jdk.httpclient.keepalive.timeout", 1200);
    final HashMap<CacheKey, LinkedList<HttpConnection>> plainPool = new HashMap();
    final HashMap<CacheKey, LinkedList<HttpConnection>> sslPool = new HashMap();
    CacheCleaner cleaner;
    final LinkedList<ExpiryEntry> expiryList = new LinkedList();

    ConnectionPool() {
    }

    void start() {
    }

    static CacheKey cacheKey(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        return new CacheKey(inetSocketAddress, inetSocketAddress2);
    }

    synchronized HttpConnection getConnection(boolean bl, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        CacheKey cacheKey = new CacheKey(inetSocketAddress, inetSocketAddress2);
        HttpConnection httpConnection = bl ? this.findConnection(cacheKey, this.sslPool) : this.findConnection(cacheKey, this.plainPool);
        return httpConnection;
    }

    synchronized void returnToPool(HttpConnection httpConnection) {
        if (httpConnection instanceof PlainHttpConnection) {
            this.putConnection(httpConnection, this.plainPool);
        } else {
            this.putConnection(httpConnection, this.sslPool);
        }
        this.addToExpiryList(httpConnection);
    }

    private HttpConnection findConnection(CacheKey cacheKey, HashMap<CacheKey, LinkedList<HttpConnection>> hashMap) {
        LinkedList<HttpConnection> linkedList = hashMap.get(cacheKey);
        if (linkedList == null || linkedList.size() == 0) {
            return null;
        }
        HttpConnection httpConnection = linkedList.removeFirst();
        this.removeFromExpiryList(httpConnection);
        return httpConnection;
    }

    private void removeFromPool(HttpConnection httpConnection, HashMap<CacheKey, LinkedList<HttpConnection>> hashMap) {
        LinkedList<HttpConnection> linkedList = hashMap.get(httpConnection.cacheKey());
        assert (linkedList != null);
        boolean bl = linkedList.remove(httpConnection);
        assert (bl);
    }

    private void putConnection(HttpConnection httpConnection, HashMap<CacheKey, LinkedList<HttpConnection>> hashMap) {
        CacheKey cacheKey = httpConnection.cacheKey();
        LinkedList<HttpConnection> linkedList = hashMap.get(cacheKey);
        if (linkedList == null) {
            linkedList = new LinkedList();
            hashMap.put(cacheKey, linkedList);
        }
        linkedList.add(httpConnection);
    }

    synchronized void removeFromExpiryList(HttpConnection httpConnection) {
        if (httpConnection == null) {
            return;
        }
        ListIterator listIterator = this.expiryList.listIterator();
        while (listIterator.hasNext()) {
            ExpiryEntry expiryEntry = (ExpiryEntry)listIterator.next();
            if (!expiryEntry.connection.equals(httpConnection)) continue;
            listIterator.remove();
            return;
        }
        if (this.expiryList.isEmpty()) {
            this.cleaner.stopCleaner();
            this.cleaner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        long l = System.currentTimeMillis() / 1000L;
        LinkedList<HttpConnection> linkedList = new LinkedList<HttpConnection>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ListIterator object = this.expiryList.listIterator();
            while (object.hasNext()) {
                ExpiryEntry expiryEntry = (ExpiryEntry)object.next();
                if (expiryEntry.expiry > l) continue;
                object.remove();
                HttpConnection httpConnection = expiryEntry.connection;
                linkedList.add(httpConnection);
                if (httpConnection instanceof PlainHttpConnection) {
                    this.removeFromPool(httpConnection, this.plainPool);
                    continue;
                }
                this.removeFromPool(httpConnection, this.sslPool);
            }
        }
        for (HttpConnection httpConnection : linkedList) {
            httpConnection.close();
        }
    }

    private synchronized void addToExpiryList(HttpConnection httpConnection) {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = l + KEEP_ALIVE;
        if (this.expiryList.isEmpty()) {
            this.cleaner = new CacheCleaner();
            this.cleaner.start();
        }
        ListIterator<ExpiryEntry> listIterator = this.expiryList.listIterator();
        while (listIterator.hasNext()) {
            ExpiryEntry expiryEntry = (ExpiryEntry)listIterator.next();
            if (l2 <= expiryEntry.expiry) continue;
            listIterator.previous();
            listIterator.add(new ExpiryEntry(httpConnection, l2));
            return;
        }
        this.expiryList.add(new ExpiryEntry(httpConnection, l2));
    }

    final class CacheCleaner
    extends Thread {
        volatile boolean stopping;

        CacheCleaner() {
            super(null, null, "HTTP-Cache-cleaner");
            this.setDaemon(true);
        }

        synchronized boolean stopping() {
            return this.stopping;
        }

        synchronized void stopCleaner() {
            this.stopping = true;
        }

        @Override
        public void run() {
            while (!this.stopping()) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ConnectionPool.this.cleanCache();
            }
        }
    }

    static class ExpiryEntry {
        final HttpConnection connection;
        final long expiry;

        ExpiryEntry(HttpConnection httpConnection, long l) {
            this.connection = httpConnection;
            this.expiry = l;
        }
    }

    static class CacheKey {
        final InetSocketAddress proxy;
        final InetSocketAddress destination;

        CacheKey(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            this.proxy = inetSocketAddress2;
            this.destination = inetSocketAddress;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (!Objects.equals(this.proxy, cacheKey.proxy)) {
                return false;
            }
            return Objects.equals(this.destination, cacheKey.destination);
        }

        public int hashCode() {
            return Objects.hash(this.proxy, this.destination);
        }
    }
}

