/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import java.io.File;
import java.util.Stack;
import net.sf.antcontrib.design.Depends;
import net.sf.antcontrib.design.Design;
import net.sf.antcontrib.design.Log;
import net.sf.antcontrib.design.Package;
import org.apache.tools.ant.Location;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class DesignFileHandler
implements ContentHandler {
    private static final String DESIGN = "design";
    private static final String PACKAGE = "package";
    private static final String DEPENDS = "depends";
    private Log log = null;
    private File file = null;
    private boolean isCircularDesign;
    private boolean needDeclarationsDefault = true;
    private boolean needDependsDefault = true;
    private Design design = null;
    private Package currentPackage = null;
    private Stack stack = new Stack();
    private Locator locator = null;
    private Location loc;

    DesignFileHandler(Log log, File file, boolean isCircularDesign, Location loc) {
        this.log = log;
        this.file = file;
        this.isCircularDesign = isCircularDesign;
        this.loc = loc;
    }

    public void setNeedDeclarationsDefault(boolean b) {
        this.needDeclarationsDefault = b;
    }

    public void setNeedDependsDefault(boolean b) {
        this.needDependsDefault = b;
    }

    public Design getDesign() {
        return this.design;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        this.log.log("publicId=" + publicId + " systemId=" + systemId, 3);
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        this.log.log("Parsing startElement=" + name, 4);
        if (name == null || "".equals(name)) {
            name = qName;
        }
        try {
            Object o = null;
            if (name.equals(DESIGN)) {
                o = this.handleDesign(attrs);
            } else if (name.equals(PACKAGE)) {
                this.currentPackage = this.handlePackage(attrs);
                o = this.currentPackage;
            } else if (name.equals(DEPENDS)) {
                o = this.handleDepends(attrs);
            } else {
                throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", Unexpected element \"" + name + "\"", this.locator);
            }
            this.stack.push(o);
        }
        catch (RuntimeException e) {
            this.log.log("exception111111111111111111", 2);
            throw new SAXParseException("PRoblem parsing", this.locator, e);
        }
    }

    private Design handleDesign(Attributes attrs) throws SAXParseException {
        if (attrs.getLength() > 0) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", no attributes allowed for " + DESIGN + " element", this.locator);
        }
        if (this.stack.size() > 0) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", " + DESIGN + " cannot be a subelement of " + this.stack.pop(), this.locator);
        }
        if (attrs.getLength() > 0) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", " + DESIGN + " element can't have any attributes", this.locator);
        }
        this.design = new Design(this.isCircularDesign, this.log, this.loc);
        return this.design;
    }

    private Package handlePackage(Attributes attrs) throws SAXParseException {
        if (this.stack.size() <= 0 || !(this.stack.peek() instanceof Design)) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", " + PACKAGE + " element must be nested in a " + DESIGN + " element", this.locator);
        }
        int len = attrs.getLength();
        String name = null;
        String thePackage = null;
        String depends = null;
        String subpackages = null;
        String needDeclarations = null;
        String needDepends = null;
        for (int i = 0; i < len; ++i) {
            String attrName = attrs.getLocalName(i);
            if ("".equals(attrName)) {
                attrName = attrs.getQName(i);
            }
            String value = attrs.getValue(i);
            this.log.log("attr=" + attrName + " value=" + value, 4);
            if ("name".equals(attrName)) {
                name = value;
                continue;
            }
            if (PACKAGE.equals(attrName)) {
                thePackage = value;
                continue;
            }
            if (DEPENDS.equals(attrName)) {
                depends = value;
                continue;
            }
            if ("subpackages".equals(attrName)) {
                subpackages = value;
                continue;
            }
            if ("needdeclarations".equals(attrName)) {
                needDeclarations = value;
                continue;
            }
            if ("needdepends".equals(attrName)) {
                needDepends = value;
                continue;
            }
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + "\n'" + attrName + "' attribute is an invalid attribute for the package element", this.locator);
        }
        if (subpackages == null) {
            subpackages = "exclude";
        }
        if (needDeclarations == null) {
            needDeclarations = Boolean.toString(this.needDeclarationsDefault);
        }
        if (needDepends == null) {
            needDepends = Boolean.toString(this.needDependsDefault);
        }
        if (name == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must contain the 'name' attribute", this.locator);
        }
        if (thePackage == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must contain the 'package' attribute", this.locator);
        }
        if (!"include".equals(subpackages) && !"exclude".equals(subpackages)) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + "\nThe subpackages attribute in the package element can only have a\nvalue of \"include\" or \"exclude\".  value='" + subpackages + "'", this.locator);
        }
        if (!"true".equals(needDeclarations) && !"false".equals(needDeclarations)) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + "\nThe needdeclarations attribute in the package element can only have a\nvalue of \"true\" or \"false\".  value='" + needDeclarations + "'", this.locator);
        }
        if (!"true".equals(needDepends) && !"false".equals(needDepends)) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + "\nThe needdepends attribute in the package element can only have a\nvalue of \"true\" or \"false\".  value='" + needDepends + "'", this.locator);
        }
        Package p = new Package();
        p.setName(name);
        p.setPackage(thePackage);
        if ("exclude".equals(subpackages)) {
            p.setIncludeSubpackages(false);
        } else {
            p.setIncludeSubpackages(true);
        }
        if ("true".equals(needDeclarations)) {
            p.setNeedDeclarations(true);
        } else {
            p.setNeedDeclarations(false);
        }
        if ("true".equals(needDepends)) {
            p.setNeedDepends(true);
        } else {
            p.setNeedDepends(false);
        }
        if (depends != null) {
            p.addDepends(new Depends(depends));
        }
        return p;
    }

    private Depends handleDepends(Attributes attrs) throws SAXParseException {
        if (this.stack.size() <= 0 || !(this.stack.peek() instanceof Package)) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", " + DEPENDS + " element must be nested in a " + PACKAGE + " element", this.locator);
        }
        if (attrs.getLength() > 0) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", " + DEPENDS + " element can't have any attributes", this.locator);
        }
        return new Depends();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            Object o = this.stack.pop();
            if (o instanceof Package) {
                Package p = (Package)o;
                Package tmp = this.design.getPackage(p.getName());
                if (tmp != null) {
                    throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + "\nname attribute on " + PACKAGE + " element has the same\nname as another package.  name=\"" + p.getName() + "\" is used twice or more", this.locator);
                }
                this.design.addConfiguredPackage(p);
                this.currentPackage = null;
            } else if (o instanceof Depends) {
                Depends d = (Depends)o;
                this.currentPackage.addDepends(d);
            }
        }
        catch (RuntimeException e) {
            throw new SAXParseException("exception", this.locator, e);
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            Object o = this.stack.peek();
            if (o instanceof Depends) {
                String s = new String(ch, start, length);
                Depends d = (Depends)o;
                if (d.getName() != null) {
                    d.setName(d.getName() + s.trim());
                } else {
                    d.setName(s.trim());
                }
            }
        }
        catch (RuntimeException e) {
            this.log.log("exception3333333333333333333", 2);
            throw new SAXParseException("exception", this.locator, e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }
}

