/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.binding.bool;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import jakarta.mvc.tck.tests.binding.bool.BindingBooleanController;
import jakarta.mvc.tck.tests.binding.bool.BindingBooleanForm;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class BindingBooleanTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(BindingBooleanController.class).addClass(BindingBooleanForm.class).addView("binding/bool/form.jsp").addView("binding/bool/result.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="boolean_type", id="convert-boolean")})
    public void submitBooleanAsTrue() throws IOException {
        HtmlPage resultPage = this.submitForm("true");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Primitive: [true]"), (Matcher)CoreMatchers.containsString((String)"Wrapper: [true]")));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="boolean_type", id="convert-boolean")})
    public void submitBooleanAsOn() throws IOException {
        HtmlPage resultPage = this.submitForm("on");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Primitive: [true]"), (Matcher)CoreMatchers.containsString((String)"Wrapper: [true]")));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="boolean_type", id="convert-boolean")})
    public void submitBooleanAsFalse() throws IOException {
        HtmlPage resultPage = this.submitForm("false");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Primitive: [false]"), (Matcher)CoreMatchers.containsString((String)"Wrapper: [false]")));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="boolean_type", id="convert-boolean")})
    public void submitBooleanAsFoobar() throws IOException {
        HtmlPage resultPage = this.submitForm("foobar");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Primitive: [false]"), (Matcher)CoreMatchers.containsString((String)"Wrapper: [false]")));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="boolean_type", id="convert-empty-boolean")})
    public void submitBooleanAsEmpty() throws IOException {
        HtmlPage resultPage = this.submitForm("");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Primitive: [false]"), (Matcher)CoreMatchers.containsString((String)"Wrapper: [null]")));
    }

    private HtmlPage submitForm(String value) throws IOException {
        HtmlPage formPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/binding/bool");
        Assert.assertThat((Object)formPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        HtmlElement ageInput = (HtmlElement)formPage.getElementById("input");
        ageInput.type(value);
        return (HtmlPage)formPage.getElementById("submit").click();
    }
}

