/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlWeekInput
extends HtmlInput {
    private static DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-'W'ww");

    HtmlWeekInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        if (!this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED) || this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_NOT_SUPPORTED) || StringUtils.isEmpty((CharSequence)newValue)) {
            super.setValueAttribute(newValue);
            return;
        }
        try {
            FORMATTER_.parse(newValue);
            super.setValueAttribute(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }
}

