/*
 * Copyright (c) 2008, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.jaxb_tck.lib;

import java.io.File;
import java.util.Map;

import com.sun.javatest.TestSuite;
import com.sun.javatest.Harness;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;

/**
 * @author Evgueni M. Astigueevitch
 * @version 1.10
 */
public class JaxbTckTestSuite extends TestSuite {

    public JaxbTckTestSuite(File root, Map tsInfo, ClassLoader cl) throws Fault {
        super(root, tsInfo, cl);
    }

    public void starting(Harness harness) throws Fault {
        JaxbTckScript.schemaCache.clear();
    }

    public TestFilter createTestFilter(TestEnvironment env) {
        return new JaxbTestFilter(env);
    }

}
