/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.PushDownDescriptor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.HierarchyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEditGroup;

public final class PushDownRefactoringProcessor
extends HierarchyProcessor {
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_PUSH = "push";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.pushDownProcessor";
    private static final GroupCategorySet SET_PUSH_DOWN = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.pushDown", RefactoringCoreMessages.PushDownRefactoring_category_name, RefactoringCoreMessages.PushDownRefactoring_category_description));
    private ITypeHierarchy fCachedClassHierarchy;
    private MemberActionInfo[] fMemberInfos;

    private static MemberActionInfo[] createInfosForAllPushableFieldsAndMethods(IType type) throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>();
        IMember[] iMemberArray = RefactoringAvailabilityTesterCore.getPushDownMembers(type);
        int n = iMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMember pushableMember = iMemberArray[n2];
            result.add(MemberActionInfo.create(pushableMember, 2));
            ++n2;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private static IMember[] getAbstractMembers(IMember[] members) throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(members.length);
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++n2;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private static CompilationUnitRewrite getCompilationUnitRewrite(Map<ICompilationUnit, CompilationUnitRewrite> rewrites, ICompilationUnit unit) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private static IJavaElement[] getReferencingElementsFromSameClass(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull((Object)member);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24);
        if (pattern == null) {
            return new IJavaElement[0];
        }
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(pattern);
        engine.setFiltering(true, true);
        IType declaringType = member.getDeclaringType();
        engine.setScope(SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{declaringType}));
        engine.setStatus(status);
        engine.searchPattern(pm);
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(3);
        ICompilationUnit cu = member.getCompilationUnit();
        String source = cu.getSource();
        CompilationUnit cuRoot = null;
        SearchResultGroup[] searchResultGroupArray = (SearchResultGroup[])engine.getResults();
        int n = searchResultGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            SearchMatch[] searchMatchArray = group.getSearchResults();
            int n3 = searchMatchArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block9: {
                    SearchMatch searchResult;
                    block10: {
                        MethodInvocation methodInvocation;
                        Expression expression;
                        block11: {
                            ASTNode node;
                            searchResult = searchMatchArray[n4];
                            if (source.charAt(searchResult.getOffset() - 1) != '.') break block10;
                            if (cuRoot == null) {
                                cuRoot = PushDownRefactoringProcessor.getCompilationUnitRoot(cu, source);
                            }
                            if (cuRoot == null || (node = NodeFinder.perform((ASTNode)cuRoot, (int)searchResult.getOffset(), (int)searchResult.getLength())) == null || !(node instanceof MethodInvocation) || (expression = (methodInvocation = (MethodInvocation)node).getExpression()) == null || expression instanceof ThisExpression) break block10;
                            if (!(expression instanceof ClassInstanceCreation)) break block11;
                            ClassInstanceCreation cic = (ClassInstanceCreation)expression;
                            Type t = cic.getType();
                            if (!t.isSimpleType() || ((SimpleType)t).getName().getFullyQualifiedName().equals(declaringType.getElementName())) break block10;
                            break block9;
                        }
                        if (expression instanceof SimpleName) {
                            String referenceName = ((SimpleName)expression).getFullyQualifiedName();
                            TypeDeclaration thisType = ASTNodes.getFirstAncestorOrNull((ASTNode)methodInvocation, TypeDeclaration.class);
                            if (thisType != null) {
                                String thisTypeName = thisType.getName().getFullyQualifiedName();
                                FieldDeclaration[] fieldDeclarationArray = thisType.getFields();
                                int n5 = fieldDeclarationArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    FieldDeclaration fieldDeclaration = fieldDeclarationArray[n6];
                                    List fragments = fieldDeclaration.fragments();
                                    for (VariableDeclarationFragment fragment : fragments) {
                                        SimpleType simpleType;
                                        Type fieldType;
                                        SimpleName name = fragment.getName();
                                        if (!name.getFullyQualifiedName().equals(referenceName) || (fieldType = fieldDeclaration.getType()).isSimpleType() && (simpleType = (SimpleType)fieldType).getName().getFullyQualifiedName().equals(thisTypeName)) {
                                            continue;
                                        }
                                        break block9;
                                    }
                                    ++n6;
                                }
                            }
                        }
                    }
                    result.add(SearchUtils.getEnclosingJavaElement(searchResult));
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    private static IJavaElement[] getReferencingElementsFromProject(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull((Object)member);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24);
        if (pattern == null) {
            return new IJavaElement[0];
        }
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(pattern);
        engine.setFiltering(true, true);
        IType declaringType = member.getDeclaringType();
        engine.setScope(SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getJavaProject()}));
        engine.setStatus(status);
        engine.searchPattern(pm);
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(3);
        ICompilationUnit cu = member.getCompilationUnit();
        String source = cu.getSource();
        CompilationUnit cuRoot = null;
        SearchResultGroup[] searchResultGroupArray = (SearchResultGroup[])engine.getResults();
        int n = searchResultGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            source = group.getCompilationUnit().getSource();
            SearchMatch[] searchMatchArray = group.getSearchResults();
            int n3 = searchMatchArray.length;
            int n4 = 0;
            while (n4 < n3) {
                SearchMatch searchResult = searchMatchArray[n4];
                if (source.charAt(searchResult.getOffset() - 1) == '.') {
                    ASTNode node;
                    if (cuRoot == null) {
                        cuRoot = PushDownRefactoringProcessor.getCompilationUnitRoot(cu, source);
                    }
                    if (cuRoot != null && (node = NodeFinder.perform((ASTNode)cuRoot, (int)searchResult.getOffset(), (int)searchResult.getLength())) != null && node instanceof MethodInvocation) {
                        IVariableBinding varBinding;
                        IBinding binding;
                        ClassInstanceCreation cic;
                        Type t;
                        Expression expression;
                        ITypeBinding nodeTypeDeclBinding;
                        MethodInvocation methodInvocation = (MethodInvocation)node;
                        TypeDeclaration nodeTypeDecl = ASTNodes.getFirstAncestorOrNull(node, TypeDeclaration.class);
                        if (!(nodeTypeDecl == null || (nodeTypeDeclBinding = nodeTypeDecl.resolveBinding()) != null && nodeTypeDeclBinding.getQualifiedName().equals(declaringType.getFullyQualifiedName()) || (expression = methodInvocation.getExpression()) != null && !(expression instanceof ThisExpression) && (expression instanceof ClassInstanceCreation ? (t = (cic = (ClassInstanceCreation)expression).getType()).isSimpleType() && !((SimpleType)t).getName().getFullyQualifiedName().equals(declaringType.getElementName()) : expression instanceof SimpleName && (!((binding = ((SimpleName)expression).resolveBinding()) instanceof IVariableBinding) || !(varBinding = (IVariableBinding)binding).getType().getQualifiedName().equals(declaringType.getFullyQualifiedName()))))) {
                            result.add(SearchUtils.getEnclosingJavaElement(searchResult));
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    private static CompilationUnit getCompilationUnitRoot(ICompilationUnit cu, String source) {
        Map options = cu.getJavaProject().getOptions(true);
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setSource(source.toCharArray());
        parser.setCompilerOptions(options);
        parser.setProject(cu.getJavaProject());
        parser.setUnitName(cu.getElementName());
        CompilationUnit selectionCURoot = (CompilationUnit)parser.createAST(null);
        return selectionCURoot;
    }

    public PushDownRefactoringProcessor(IMember[] members) {
        super(members, null, false);
        if (members != null) {
            IType type = RefactoringAvailabilityTesterCore.getTopLevelType(members);
            try {
                if (type != null && RefactoringAvailabilityTesterCore.getPushDownMembers(type).length != 0) {
                    this.fMembersToMove = new IMember[0];
                    this.fCachedDeclaringType = type;
                }
            }
            catch (JavaModelException exception) {
                JavaManipulationPlugin.log(exception);
            }
        }
    }

    public PushDownRefactoringProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        super(null, null, false);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    private void addAllRequiredPushableMembers(List<IMember> queue, IMember member, IProgressMonitor monitor) throws JavaModelException {
        IMethod[] requiredMethods;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_calculating_required, (int)2);
        IMethod[] iMethodArray = requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)sub.newChild(1));
        int n = requiredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!MethodChecks.isVirtual(method) && method.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(method) && RefactoringAvailabilityTesterCore.isPushDownAvailable((IMember)method)) {
                queue.add((IMember)method);
            }
            ++n2;
        }
        iMethodArray = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)sub.newChild(1));
        n = iMethodArray.length;
        n2 = 0;
        while (n2 < n) {
            IMethod field = iMethodArray[n2];
            if (field.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(field) && RefactoringAvailabilityTesterCore.isPushDownAvailable((IMember)field)) {
                queue.add((IMember)field);
            }
            ++n2;
        }
    }

    private RefactoringStatus checkAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForAbstract) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] abstractMembersToPushDown = PushDownRefactoringProcessor.getAbstractMembers(membersToPushDown);
        IType[] iTypeArray = destinationClassesForAbstract;
        int n = destinationClassesForAbstract.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.merge(MemberCheckUtil.checkMembersInDestinationType(abstractMembersToPushDown, type));
            ++n2;
        }
        return result;
    }

    private RefactoringStatus checkAccessedFields(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])membersToPushDown, pm);
        IType[] iTypeArray = subclasses;
        int n = subclasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType targetClass = iTypeArray[n2];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            IField[] iFieldArray = accessedFields;
            int n3 = accessedFields.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean isAccessible;
                IField field = iFieldArray[n4];
                boolean bl = isAccessible = pushedDownList.contains(field) || this.canBeAccessedFrom((IMember)field, targetClass, targetSupertypes) || Flags.isEnum((int)field.getFlags());
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_field_not_accessible, new String[]{JavaElementLabelsCore.getTextLabel(field, 2235681801344L), JavaElementLabelsCore.getTextLabel(targetClass, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                }
                ++n4;
            }
            ++n2;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])membersToPushDown, pm);
        IType[] iTypeArray = subclasses;
        int n = subclasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType targetClass = iTypeArray[n2];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            IMethod[] iMethodArray = accessedMethods;
            int n3 = accessedMethods.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean isAccessible;
                IMethod method = iMethodArray[n4];
                boolean bl = isAccessible = pushedDownList.contains(method) || this.canBeAccessedFrom((IMember)method, targetClass, targetSupertypes);
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_method_not_accessible, new String[]{JavaElementLabelsCore.getTextLabel(method, 2235681801344L), JavaElementLabelsCore.getTextLabel(targetClass, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create((IMember)method));
                }
                ++n4;
            }
            ++n2;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypesReferencedInMovedMembers(pm);
        IType[] iTypeArray = subclasses;
        int n = subclasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType targetClass = iTypeArray[n2];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            IType[] iTypeArray2 = accessedTypes;
            int n3 = accessedTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                IType type = iTypeArray2[n4];
                if (!this.canBeAccessedFrom((IMember)type, targetClass, targetSupertypes)) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_type_not_accessible, new String[]{JavaElementLabelsCore.getTextLabel(type, 2235681801344L), JavaElementLabelsCore.getTextLabel(targetClass, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create((IMember)type));
                }
                ++n4;
            }
            ++n2;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkElementsAccessedByModifiedMembers(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)pm, (String)RefactoringCoreMessages.PushDownRefactoring_check_references, (int)4);
        IType[] subclasses = this.getAbstractDestinations((IProgressMonitor)subMon.newChild(1));
        result.merge(this.checkAccessedTypes(subclasses, (IProgressMonitor)subMon.newChild(1)));
        result.merge(this.checkAccessedFields(subclasses, (IProgressMonitor)subMon.newChild(1)));
        result.merge(this.checkAccessedMethods(subclasses, (IProgressMonitor)subMon.newChild(1)));
        pm.done();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_checking, (int)5);
            this.clearCaches();
            ICompilationUnit unit = this.getDeclaringType().getCompilationUnit();
            if (this.fLayer) {
                unit = unit.findWorkingCopy((WorkingCopyOwner)this.fOwner);
            }
            this.resetWorkingCopies(unit);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkMembersInDestinationClasses((IProgressMonitor)subMon.newChild(1)));
            result.merge(this.checkElementsAccessedByModifiedMembers((IProgressMonitor)subMon.newChild(1)));
            result.merge(this.checkReferencesToPushedDownMembers((IProgressMonitor)subMon.newChild(1)));
            if (!JdtFlags.isAbstract((IMember)this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                result.merge(this.checkConstructorCalls(this.getDeclaringType(), (IProgressMonitor)subMon.newChild(1)));
            } else {
                subMon.setWorkRemaining(1);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            ArrayList<IMember> members = new ArrayList<IMember>(this.fMemberInfos.length);
            MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
            int n = this.fMemberInfos.length;
            int n2 = 0;
            while (n2 < n) {
                MemberActionInfo memberInfo = memberActionInfoArray[n2];
                if (memberInfo.getAction() != 2) {
                    members.add(memberInfo.getMember());
                }
                ++n2;
            }
            this.fMembersToMove = members.toArray(new IMember[members.size()]);
            this.fChangeManager = this.createChangeManager((IProgressMonitor)subMon.newChild(1), result);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            Checks.addModifiedFilesToChecker(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), context);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_checking, (int)2);
            RefactoringStatus status = new RefactoringStatus();
            status.merge(this.checkPossibleSubclasses((IProgressMonitor)subMon.newChild(1)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            status.merge(this.checkDeclaringType((IProgressMonitor)subMon.newChild(1)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            status.merge(this.checkIfMembersExist());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            this.fMemberInfos = PushDownRefactoringProcessor.createInfosForAllPushableFieldsAndMethods(this.getDeclaringType());
            List<IMember> list = Arrays.asList(this.fMembersToMove);
            MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
            int n = this.fMemberInfos.length;
            int n2 = 0;
            while (n2 < n) {
                MemberActionInfo info = memberActionInfoArray[n2];
                if (list.contains(info.getMember())) {
                    info.setAction(0);
                }
                ++n2;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus checkMembersInDestinationClasses(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_checking, (int)2);
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        IType[] destinationClassesForNonAbstract = this.getAbstractDestinations((IProgressMonitor)subMon.newChild(1));
        result.merge(this.checkNonAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForNonAbstract));
        List<IMember> list = Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers((IMember[])this.getAbstractDestinations((IProgressMonitor)subMon.newChild(1))));
        IType[] destinationClassesForAbstract = list.toArray(new IType[list.size()]);
        result.merge(this.checkAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForAbstract));
        monitor.done();
        return result;
    }

    private RefactoringStatus checkNonAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForNonAbstract) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        ArrayList<IMember> list = new ArrayList<IMember>(Arrays.asList(membersToPushDown));
        list.removeAll(Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers(membersToPushDown)));
        IMember[] nonAbstractMembersToPushDown = list.toArray(new IMember[list.size()]);
        IType[] iTypeArray = destinationClassesForNonAbstract;
        int n = destinationClassesForNonAbstract.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.merge(MemberCheckUtil.checkMembersInDestinationType(nonAbstractMembersToPushDown, type));
            ++n2;
        }
        return result;
    }

    private RefactoringStatus checkPossibleSubclasses(IProgressMonitor pm) throws JavaModelException {
        IType[] modifiableSubclasses = this.getAbstractDestinations(pm);
        if (modifiableSubclasses.length == 0) {
            String msg = Messages.format(RefactoringCoreMessages.PushDownRefactoring_no_subclasses, new String[]{JavaElementLabelsCore.getTextLabel(this.getDeclaringType(), 2235681801344L)});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkReferencesToPushedDownMembers(IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IMember> fields = new ArrayList<IMember>(this.fMemberInfos.length);
        MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
        int n = this.fMemberInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MemberActionInfo info = memberActionInfoArray[n2];
            if (info.isToBePushedDown()) {
                fields.add(info.getMember());
            }
            ++n2;
        }
        IMember[] membersToPush = fields.toArray(new IMember[fields.size()]);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> movedMembers = Arrays.asList(MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass()));
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_check_references, (int)membersToPush.length);
        IMember[] iMemberArray = membersToPush;
        int n3 = membersToPush.length;
        int n4 = 0;
        while (n4 < n3) {
            IJavaElement element;
            IMember member = iMemberArray[n4];
            String label = PushDownRefactoringProcessor.createLabel(member);
            IJavaElement[] iJavaElementArray = PushDownRefactoringProcessor.getReferencingElementsFromProject(member, (IProgressMonitor)subMon.newChild(1), result);
            int n5 = iJavaElementArray.length;
            int n6 = 0;
            while (n6 < n5) {
                element = iJavaElementArray[n6];
                IMember referencingMember = (IMember)element;
                Object[] keys = new Object[]{label, PushDownRefactoringProcessor.createLabel(referencingMember)};
                String msg = Messages.format(RefactoringCoreMessages.PushDownRefactoring_referenced, keys);
                result.addError(msg, JavaStatusContext.create(referencingMember));
                ++n6;
            }
            iJavaElementArray = PushDownRefactoringProcessor.getReferencingElementsFromSameClass(member, (IProgressMonitor)subMon.newChild(1), result);
            n5 = iJavaElementArray.length;
            n6 = 0;
            while (n6 < n5) {
                element = iJavaElementArray[n6];
                if (!movedMembers.contains(element) && element instanceof IMember) {
                    IType[] destinationTypes = this.getAbstractDestinations((IProgressMonitor)new NullProgressMonitor());
                    IMember elementMember = (IMember)element;
                    IType elementMemberType = elementMember.getDeclaringType();
                    boolean isMoveDestination = false;
                    IType[] iTypeArray = destinationTypes;
                    int n7 = destinationTypes.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        IType destinationType = iTypeArray[n8];
                        if (destinationType.getFullyQualifiedName().equals(elementMemberType.getFullyQualifiedName())) {
                            isMoveDestination = true;
                            break;
                        }
                        ++n8;
                    }
                    if (!isMoveDestination) {
                        IMember referencingMember = (IMember)element;
                        Object[] keys = new Object[]{label, PushDownRefactoringProcessor.createLabel(referencingMember)};
                        String msg = Messages.format(RefactoringCoreMessages.PushDownRefactoring_referenced, keys);
                        result.addError(msg, JavaStatusContext.create(referencingMember));
                    }
                }
                ++n6;
            }
            ++n4;
        }
        return result;
    }

    public void computeAdditionalRequiredMembersToPushDown(IProgressMonitor monitor) throws JavaModelException {
        List<IMember> list = Arrays.asList(this.getAdditionalRequiredMembers(monitor));
        MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
        int n = this.fMemberInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MemberActionInfo info = memberActionInfoArray[n2];
            if (list.contains(info.getMember())) {
                info.setAction(0);
            }
            ++n2;
        }
    }

    private void copyBodyOfPushedDownMethod(ASTRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod, TypeVariableMaplet[] mapping) throws JavaModelException {
        Block body = oldMethod.getBody();
        if (body == null) {
            newMethod.setBody(null);
            return;
        }
        try {
            Document document = new Document(method.getCompilationUnit().getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)body.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)body);
            body.accept((ASTVisitor)new HierarchyProcessor.TypeVariableMapper(rewriter, mapping));
            body.accept((ASTVisitor)new ThisVisitor(rewriter, this.fCachedDeclaringType));
            body.accept((ASTVisitor)new MemberVisitor(rewriter, this.fCachedDeclaringType, this.getHierarchyOfDeclaringClass((IProgressMonitor)new NullProgressMonitor()), this.getAbstractDestinations((IProgressMonitor)new NullProgressMonitor())));
            rewriter.rewriteAST((IDocument)document, this.getDeclaringType().getCompilationUnit().getOptions(true)).apply((IDocument)document, 0);
            String content = document.get(position.getStartPosition(), position.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, method.getCompilationUnit(), false);
            content = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
            newMethod.setBody((Block)targetRewrite.createStringPlaceholder(content, 8));
        }
        catch (BadLocationException | MalformedTreeException exception) {
            JavaManipulationPlugin.log(exception);
        }
    }

    private void copyMembers(Collection<MemberVisibilityAdjustor> adjustors, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, Map<ICompilationUnit, CompilationUnitRewrite> rewrites, RefactoringStatus status, MemberActionInfo[] infos, IType[] destinations, CompilationUnitRewrite sourceRewriter, CompilationUnitRewrite unitRewriter, IProgressMonitor monitor) throws JavaModelException {
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_checking, (int)(destinations.length * infos.length));
            IType type = null;
            TypeVariableMaplet[] mapping = null;
            IType[] iTypeArray = destinations;
            int n = destinations.length;
            int n2 = 0;
            while (n2 < n) {
                IType destination;
                type = destination = iTypeArray[n2];
                mapping = TypeVariableUtil.superTypeToInheritedType(this.getDeclaringType(), type);
                if (unitRewriter.getCu().equals(type.getCompilationUnit())) {
                    IMember member = null;
                    MemberVisibilityAdjustor adjustor = null;
                    AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, unitRewriter.getRoot());
                    ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)declaration, unitRewriter.getImportRewrite());
                    int offset = infos.length - 1;
                    while (offset >= 0) {
                        member = infos[offset].getMember();
                        adjustor = new MemberVisibilityAdjustor((IJavaElement)type, member);
                        if (infos[offset].isNewMethodToBeDeclaredAbstract()) {
                            adjustor.setIncoming(false);
                        }
                        adjustor.setRewrite(sourceRewriter.getASTRewrite(), sourceRewriter.getRoot());
                        adjustor.setRewrites(rewrites);
                        adjustor.setFailureSeverity(2);
                        adjustor.setStatus(status);
                        adjustor.setAdjustments(adjustments);
                        adjustor.adjustVisibility((IProgressMonitor)subMon.newChild(1));
                        adjustments.remove(member);
                        adjustors.add(adjustor);
                        status.merge(PushDownRefactoringProcessor.checkProjectCompliance());
                        if (infos[offset].isFieldInfo()) {
                            VariableDeclarationFragment oldField = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)infos[offset].getMember(), sourceRewriter.getRoot());
                            if (oldField != null) {
                                FieldDeclaration newField = this.createNewFieldDeclarationNode(infos[offset], sourceRewriter.getRoot(), mapping, unitRewriter.getASTRewrite(), oldField);
                                group = unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, SET_PUSH_DOWN);
                                unitRewriter.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newField, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newField, declaration.bodyDeclarations()), (TextEditGroup)group);
                                ImportRewriteUtil.addImports(unitRewriter, context, oldField.getParent(), new HashMap<Name, String>(), new HashMap<Name, String>(), false);
                                this.replaceTargetSuperFieldReferences(declaration, member, unitRewriter.getASTRewrite(), (TextEditGroup)group);
                            }
                        } else {
                            MethodDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)infos[offset].getMember(), sourceRewriter.getRoot());
                            if (oldMethod != null) {
                                MethodDeclaration newMethod = this.createNewMethodDeclarationNode(infos[offset], mapping, unitRewriter, oldMethod);
                                group = unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, SET_PUSH_DOWN);
                                unitRewriter.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newMethod, declaration.bodyDeclarations()), (TextEditGroup)group);
                                ImportRewriteUtil.addImports(unitRewriter, context, (ASTNode)oldMethod, new HashMap<Name, String>(), new HashMap<Name, String>(), false);
                                this.replaceTargetSuperMethodInvocations(declaration, member, unitRewriter.getASTRewrite(), (TextEditGroup)group);
                            }
                        }
                        --offset;
                    }
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void replaceTargetSuperMethodInvocations(AbstractTypeDeclaration declaration, final IMember member, final ASTRewrite astRewrite, final TextEditGroup group) {
        ASTVisitor removeSuperMethodInvocationVisitor = new ASTVisitor(){

            public boolean visit(SuperMethodInvocation node) {
                IMethodBinding binding = node.resolveMethodBinding();
                if (binding != null && binding.getJavaElement() != null && binding.getJavaElement().equals(member)) {
                    ListRewrite args;
                    List originalArgsList;
                    AST ast = astRewrite.getAST();
                    MethodInvocation newMethodInvocation = ast.newMethodInvocation();
                    newMethodInvocation.setName(ast.newSimpleName(node.getName().getFullyQualifiedName()));
                    ListRewrite typeArgs = astRewrite.getListRewrite((ASTNode)node, SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY);
                    List originalTypeList = typeArgs.getOriginalList();
                    if (originalTypeList.size() > 0) {
                        ASTNode typeArgsCopy = typeArgs.createCopyTarget((ASTNode)originalTypeList.get(0), (ASTNode)originalTypeList.get(originalTypeList.size() - 1));
                        newMethodInvocation.typeArguments().add(typeArgsCopy);
                    }
                    if ((originalArgsList = (args = astRewrite.getListRewrite((ASTNode)node, SuperMethodInvocation.ARGUMENTS_PROPERTY)).getOriginalList()).size() > 0) {
                        ASTNode argsCopy = typeArgs.createCopyTarget((ASTNode)originalArgsList.get(0), (ASTNode)originalArgsList.get(originalTypeList.size() - 1));
                        newMethodInvocation.arguments().add(argsCopy);
                    }
                    astRewrite.replace((ASTNode)node, (ASTNode)newMethodInvocation, group);
                    return false;
                }
                return true;
            }
        };
        declaration.accept(removeSuperMethodInvocationVisitor);
    }

    private void replaceTargetSuperFieldReferences(AbstractTypeDeclaration declaration, final IMember member, final ASTRewrite astRewrite, final TextEditGroup group) {
        ASTVisitor removeSuperFieldVisitor = new ASTVisitor(){

            public boolean visit(SuperFieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null && binding.isField() && binding.getJavaElement() != null && binding.getJavaElement().equals(member)) {
                    AST ast = astRewrite.getAST();
                    FieldAccess newFieldAccess = ast.newFieldAccess();
                    newFieldAccess.setName(ast.newSimpleName(node.getName().getFullyQualifiedName()));
                    newFieldAccess.setExpression((Expression)ast.newThisExpression());
                    astRewrite.replace((ASTNode)node, (ASTNode)newFieldAccess, group);
                    return false;
                }
                return true;
            }
        };
        declaration.accept(removeSuperFieldVisitor);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IType declaring = this.getDeclaringType();
            IJavaProject javaProject = declaring.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (declaring.isLocal() || declaring.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaManipulationPlugin.log(exception);
            }
            String description = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description_short_multi, BasicElementLabels.getJavaElementName(this.fMembersToMove[0].getElementName())) : RefactoringCoreMessages.PushDownRefactoring_descriptor_description_short;
            String header = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description_full, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)this.fMembersToMove[0], 2235681801344L), JavaElementLabelsCore.getElementLabel((IJavaElement)declaring, 2235681801344L)}) : Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)declaring, 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            String[] settings = new String[this.fMembersToMove.length];
            int index = 0;
            while (index < settings.length) {
                settings[index] = JavaElementLabelsCore.getElementLabel((IJavaElement)this.fMembersToMove[index], 2235681801344L);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.PushDownRefactoring_pushed_members_pattern, settings));
            this.addSuperTypeSettings(comment, true);
            PushDownDescriptor descriptor = RefactoringSignatureDescriptorFactory.createPushDownDescriptor(project, description, comment.asString(), arguments, flags);
            if (this.fCachedDeclaringType != null) {
                arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCachedDeclaringType));
            }
            int index2 = 0;
            while (index2 < this.fMembersToMove.length) {
                arguments.put("element" + (index2 + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fMembersToMove[index2]));
                MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
                int n = this.fMemberInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    MemberActionInfo memberInfo = memberActionInfoArray[n2];
                    if (memberInfo.getMember().equals(this.fMembersToMove[index2])) {
                        switch (memberInfo.getAction()) {
                            case 1: {
                                arguments.put(ATTRIBUTE_ABSTRACT + (index2 + 1), Boolean.TRUE.toString());
                                break;
                            }
                            case 0: {
                                arguments.put(ATTRIBUTE_PUSH + (index2 + 1), Boolean.TRUE.toString());
                            }
                        }
                    }
                    ++n2;
                }
                ++index2;
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.PushDownRefactoring_change_name, (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
            this.clearCaches();
        }
    }

    private TextEditBasedChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_checking, (int)6);
            ICompilationUnit source = this.getDeclaringType().getCompilationUnit();
            CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(source);
            HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            rewrites.put(source, sourceRewriter);
            IType[] types = this.getHierarchyOfDeclaringClass((IProgressMonitor)subMon.newChild(1)).getSubclasses(this.getDeclaringType());
            HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(types.length + 1);
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                ICompilationUnit iCompilationUnit = type.getCompilationUnit();
                if (iCompilationUnit != null) {
                    result.add(iCompilationUnit);
                }
                ++n2;
            }
            result.add(source);
            HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments = new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
            ArrayList<MemberVisibilityAdjustor> adjustors = new ArrayList<MemberVisibilityAdjustor>();
            CompilationUnitRewrite rewrite = null;
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)subMon.newChild(4), (int)(result.size() * 4));
            for (ICompilationUnit iCompilationUnit : result) {
                rewrite = PushDownRefactoringProcessor.getCompilationUnitRewrite(rewrites, iCompilationUnit);
                if (iCompilationUnit.equals(sourceRewriter.getCu())) {
                    AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDeclaringType(), rewrite.getRoot());
                    if (!JdtFlags.isAbstract((IMember)this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                        ModifierRewrite.create(rewrite.getASTRewrite(), (ASTNode)declaration).setModifiers(0x400 | declaration.getModifiers(), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PushDownRefactoring_make_abstract, SET_PUSH_DOWN));
                    }
                    PushDownRefactoringProcessor.deleteDeclarationNodes(false, rewrite, Arrays.asList(this.getDeletableMembers()), SET_PUSH_DOWN);
                    MemberActionInfo[] memberActionInfoArray = this.getAbstractDeclarationInfos();
                    int n3 = memberActionInfoArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MemberActionInfo method = memberActionInfoArray[n4];
                        this.declareMethodAbstract(method, sourceRewriter, rewrite);
                        ++n4;
                    }
                }
                IMember[] members = PushDownRefactoringProcessor.getAbstractMembers((IMember[])this.getAbstractDestinations((IProgressMonitor)sub.newChild(1)));
                IType[] classes = new IType[members.length];
                int offset = 0;
                while (offset < members.length) {
                    classes[offset] = (IType)members[offset];
                    ++offset;
                }
                this.copyMembers(adjustors, adjustments, rewrites, status, this.getAbstractMemberInfos(), classes, sourceRewriter, rewrite, (IProgressMonitor)sub.newChild(1));
                IType[] abstractDestinations = this.getAbstractDestinations((IProgressMonitor)sub.newChild(1));
                this.copyMembers(adjustors, adjustments, rewrites, status, this.getAffectedMemberInfos(), abstractDestinations, sourceRewriter, rewrite, (IProgressMonitor)sub.newChild(1));
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            this.removeOverrideAnnotation(rewrites);
            if (!adjustors.isEmpty() && !adjustments.isEmpty()) {
                MemberVisibilityAdjustor adjustor = (MemberVisibilityAdjustor)adjustors.get(0);
                adjustor.rewriteVisibility((IProgressMonitor)subMon.newChild(1));
            }
            TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            for (Map.Entry entry : rewrites.entrySet()) {
                ICompilationUnit unit = (ICompilationUnit)entry.getKey();
                rewrite = (CompilationUnitRewrite)entry.getValue();
                if (rewrite == null) continue;
                manager.manage(unit, (TextEditBasedChange)rewrite.createChange(true));
            }
            TextEditBasedChangeManager textEditBasedChangeManager = manager;
            return textEditBasedChangeManager;
        }
        finally {
            monitor.done();
        }
    }

    private void removeOverrideAnnotation(Map<ICompilationUnit, CompilationUnitRewrite> rewrites) throws JavaModelException {
        IType[] subclasses = this.fCachedClassHierarchy.getSubclasses(this.fCachedDeclaringType);
        IMember[] iMemberArray = this.fMembersToMove;
        int n = this.fMembersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IMember memberActionInfo = iMemberArray[n2];
            if (memberActionInfo.getElementType() == 9) {
                IMethod method = (IMethod)memberActionInfo;
                IType[] iTypeArray = subclasses;
                int n3 = subclasses.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType iType = iTypeArray[n4];
                    IMethod[] iMethodArray = iType.getMethods();
                    int n5 = iMethodArray.length;
                    int n6 = 0;
                    block2: while (n6 < n5) {
                        CompilationUnitRewrite rewrite;
                        MethodDeclaration methodDeclarationNode;
                        IMethod iMethod = iMethodArray[n6];
                        if (iMethod.isSimilar(method) && (methodDeclarationNode = ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, (rewrite = PushDownRefactoringProcessor.getCompilationUnitRewrite(rewrites, iType.getCompilationUnit())).getRoot())) != null) {
                            ListRewrite listRewrite = rewrite.getASTRewrite().getListRewrite((ASTNode)methodDeclarationNode, MethodDeclaration.MODIFIERS2_PROPERTY);
                            for (IExtendedModifier iExtendedModifier : methodDeclarationNode.modifiers()) {
                                if (!iExtendedModifier.isAnnotation() || !"Override".equals(((Annotation)iExtendedModifier).getTypeName().getFullyQualifiedName())) continue;
                                listRewrite.remove((ASTNode)((Annotation)iExtendedModifier), null);
                                break block2;
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private FieldDeclaration createNewFieldDeclarationNode(MemberActionInfo info, CompilationUnit declaringCuNode, TypeVariableMaplet[] mapping, ASTRewrite rewrite, VariableDeclarationFragment oldFieldFragment) throws JavaModelException {
        Assert.isTrue((boolean)info.isFieldInfo());
        IField field = (IField)info.getMember();
        AST ast = rewrite.getAST();
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        PushDownRefactoringProcessor.copyExtraDimensions((VariableDeclaration)oldFieldFragment, (VariableDeclaration)newFragment);
        Expression initializer = oldFieldFragment.getInitializer();
        if (initializer != null) {
            Expression newInitializer = null;
            newInitializer = mapping.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForExpression(initializer, field.getCompilationUnit(), mapping, rewrite) : PushDownRefactoringProcessor.createPlaceholderForExpression(initializer, field.getCompilationUnit(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName(ast.newSimpleName(oldFieldFragment.getName().getIdentifier()));
        FieldDeclaration newField = ast.newFieldDeclaration(newFragment);
        FieldDeclaration oldField = ASTNodeSearchUtil.getFieldDeclarationNode(field, declaringCuNode);
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(rewrite, (BodyDeclaration)oldField, (BodyDeclaration)newField);
        }
        PushDownRefactoringProcessor.copyAnnotations(oldField, newField);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(ast, info.getNewModifiersForCopyInSubclass(oldField.getModifiers())));
        Type oldType = oldField.getType();
        ICompilationUnit cu = field.getCompilationUnit();
        Type newType = null;
        newType = mapping.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForType(oldType, cu, mapping, rewrite) : PushDownRefactoringProcessor.createPlaceholderForType(oldType, cu, rewrite);
        newField.setType(newType);
        return newField;
    }

    private MethodDeclaration createNewMethodDeclarationNode(MemberActionInfo info, TypeVariableMaplet[] mapping, CompilationUnitRewrite rewriter, MethodDeclaration oldMethod) throws JavaModelException {
        Assert.isTrue((!info.isFieldInfo() ? 1 : 0) != 0);
        IMethod method = (IMethod)info.getMember();
        ASTRewrite rewrite = rewriter.getASTRewrite();
        AST ast = rewrite.getAST();
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        this.copyBodyOfPushedDownMethod(rewrite, method, oldMethod, newMethod, mapping);
        newMethod.setConstructor(oldMethod.isConstructor());
        PushDownRefactoringProcessor.copyExtraDimensions(oldMethod, newMethod);
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(rewrite, (BodyDeclaration)oldMethod, (BodyDeclaration)newMethod);
        }
        if (info.isNewMethodToBeDeclaredAbstract() && JavaPreferencesSettings.getCodeGenerationSettings((ICompilationUnit)rewriter.getCu()).overrideAnnotation) {
            MarkerAnnotation annotation = ast.newMarkerAnnotation();
            annotation.setTypeName((Name)ast.newSimpleName("Override"));
            newMethod.modifiers().add(annotation);
        }
        PushDownRefactoringProcessor.copyAnnotations(oldMethod, newMethod);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, info.getNewModifiersForCopyInSubclass(oldMethod.getModifiers())));
        newMethod.setName(ast.newSimpleName(oldMethod.getName().getIdentifier()));
        this.copyReturnType(rewrite, method.getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(rewrite, method.getCompilationUnit(), oldMethod, newMethod, mapping);
        PushDownRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        PushDownRefactoringProcessor.copyTypeParameters(oldMethod, newMethod);
        return newMethod;
    }

    private void declareMethodAbstract(MemberActionInfo info, CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite unitRewrite) throws JavaModelException {
        Assert.isTrue((!info.isFieldInfo() ? 1 : 0) != 0);
        IMethod method = (IMethod)info.getMember();
        if (JdtFlags.isAbstract((IMember)method)) {
            return;
        }
        MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, sourceRewrite.getRoot());
        unitRewrite.getASTRewrite().remove((ASTNode)declaration.getBody(), null);
        sourceRewrite.getImportRemover().registerRemovedNode((ASTNode)declaration.getBody());
        ModifierRewrite.create(unitRewrite.getASTRewrite(), (ASTNode)declaration).setModifiers(info.getNewModifiersForOriginal(declaration.getModifiers()), null);
    }

    private MemberActionInfo[] getAbstractDeclarationInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
        int n = this.fMemberInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MemberActionInfo info = memberActionInfoArray[n2];
            if (info.isNewMethodToBeDeclaredAbstract()) {
                result.add(info);
            }
            ++n2;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private IType[] getAbstractDestinations(IProgressMonitor monitor) throws JavaModelException {
        IType[] allDirectSubclasses = this.getHierarchyOfDeclaringClass(monitor).getSubclasses(this.getDeclaringType());
        ArrayList<IType> result = new ArrayList<IType>(allDirectSubclasses.length);
        IType[] iTypeArray = allDirectSubclasses;
        int n = allDirectSubclasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType subclass = iTypeArray[n2];
            if (subclass.exists() && !subclass.isBinary() && !subclass.isReadOnly() && subclass.getCompilationUnit() != null && subclass.isStructureKnown()) {
                result.add(subclass);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private MemberActionInfo[] getAbstractMemberInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
        int n = this.fMemberInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MemberActionInfo info = memberActionInfoArray[n2];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++n2;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public IMember[] getAdditionalRequiredMembers(IProgressMonitor monitor) throws JavaModelException {
        IMember current;
        IMember[] members = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        ArrayList<IMember> queue = new ArrayList<IMember>(Arrays.asList(members));
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PushDownRefactoring_calculating_required, (int)queue.size());
        if (queue.isEmpty()) {
            return new IMember[0];
        }
        int i = 0;
        do {
            current = (IMember)queue.get(i);
            this.addAllRequiredPushableMembers(queue, current, (IProgressMonitor)submon.newChild(1));
            submon.setWorkRemaining(queue.size());
            if (queue.size() != ++i) continue;
            current = null;
        } while (current != null);
        submon.worked(queue.size());
        queue.removeAll(Arrays.asList(members));
        return queue.toArray(new IMember[queue.size()]);
    }

    private IMember[] getDeletableMembers() {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMemberInfos.length);
        MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
        int n = this.fMemberInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MemberActionInfo info = memberActionInfoArray[n2];
            if (info.isToBeDeletedFromDeclaringClass()) {
                result.add(info.getMember());
            }
            ++n2;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private MemberActionInfo[] getAffectedMemberInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        MemberActionInfo[] memberActionInfoArray = this.fMemberInfos;
        int n = this.fMemberInfos.length;
        int n2 = 0;
        while (n2 < n) {
            MemberActionInfo info = memberActionInfoArray[n2];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && !JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++n2;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public Object[] getElements() {
        return this.fMembersToMove;
    }

    private ITypeHierarchy getHierarchyOfDeclaringClass(IProgressMonitor monitor) throws JavaModelException {
        try {
            if (this.fCachedClassHierarchy != null) {
                ITypeHierarchy iTypeHierarchy = this.fCachedClassHierarchy;
                return iTypeHierarchy;
            }
            ITypeHierarchy iTypeHierarchy = this.fCachedClassHierarchy = this.getDeclaringType().newTypeHierarchy(monitor);
            return iTypeHierarchy;
        }
        finally {
            monitor.done();
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    private MemberActionInfo[] getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass() throws JavaModelException {
        MemberActionInfo[] abs = this.getAbstractMemberInfos();
        MemberActionInfo[] nonabs = this.getAffectedMemberInfos();
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(abs.length + nonabs.length);
        result.addAll(Arrays.asList(abs));
        result.addAll(Arrays.asList(nonabs));
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public MemberActionInfo[] getMemberActionInfos() {
        return this.fMemberInfos;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.PushDownRefactoring_name;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        String handle = extended.getAttribute("input");
        if (handle != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.push.down");
            }
            this.fCachedDeclaringType = (IType)element;
        }
        int count = 1;
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        ArrayList<MemberActionInfo> infos = new ArrayList<MemberActionInfo>();
        String attribute = "element" + count;
        RefactoringStatus status = new RefactoringStatus();
        while ((handle = extended.getAttribute(attribute)) != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists()) {
                status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.push.down"));
            } else {
                elements.add(element);
            }
            if (extended.getAttribute(ATTRIBUTE_ABSTRACT + count) != null) {
                infos.add(MemberActionInfo.create((IMember)element, 1));
            } else if (extended.getAttribute(ATTRIBUTE_PUSH + count) != null) {
                infos.add(MemberActionInfo.create((IMember)element, 0));
            } else {
                infos.add(MemberActionInfo.create((IMember)element, 2));
            }
            attribute = "element" + ++count;
        }
        this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
        this.fMemberInfos = infos.toArray(new MemberActionInfo[infos.size()]);
        if (!status.isOK()) {
            return status;
        }
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTesterCore.isPushDownAvailable(this.fMembersToMove);
    }

    @Override
    protected void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set<String> replacements, IProgressMonitor monitor) throws CoreException {
    }

    public static class MemberActionInfo
    implements IMemberActionInfo {
        public static final int NO_ACTION = 2;
        public static final int PUSH_ABSTRACT_ACTION = 1;
        public static final int PUSH_DOWN_ACTION = 0;
        private int fAction;
        private final IMember fMember;

        private static void assertValidAction(IMember member, int action) {
            if (member instanceof IMethod) {
                Assert.isTrue((action == 1 || action == 2 || action == 0 ? 1 : 0) != 0);
            } else if (member instanceof IField) {
                Assert.isTrue((action == 2 || action == 0 ? 1 : 0) != 0);
            }
        }

        public static MemberActionInfo create(IMember member, int action) {
            return new MemberActionInfo(member, action);
        }

        static IMember[] getMembers(MemberActionInfo[] infos) {
            IMember[] result = new IMember[infos.length];
            int i = 0;
            while (i < result.length) {
                result[i] = infos[i].getMember();
                ++i;
            }
            return result;
        }

        private MemberActionInfo(IMember member, int action) {
            MemberActionInfo.assertValidAction(member, action);
            Assert.isTrue((member instanceof IField || member instanceof IMethod ? 1 : 0) != 0);
            this.fMember = member;
            this.fAction = action;
        }

        boolean copyJavadocToCopiesInSubclasses() {
            return this.isToBeDeletedFromDeclaringClass();
        }

        public int getAction() {
            return this.fAction;
        }

        public int[] getAvailableActions() {
            if (this.isFieldInfo()) {
                int[] nArray = new int[2];
                nArray[1] = 2;
                return nArray;
            }
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            return nArray;
        }

        public IMember getMember() {
            return this.fMember;
        }

        int getNewModifiersForCopyInSubclass(int oldModifiers) throws JavaModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract() && !JdtFlags.isPublic(this.fMember)) {
                modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
            }
            return modifiers;
        }

        int getNewModifiersForOriginal(int oldModifiers) throws JavaModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract()) {
                modifiers = JdtFlags.clearFlag(272, oldModifiers);
                modifiers |= 0x400;
                if (!JdtFlags.isPublic(this.fMember)) {
                    modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
                }
            }
            return modifiers;
        }

        @Override
        public boolean isActive() {
            return this.getAction() != 2;
        }

        public boolean isEditable() {
            if (this.isFieldInfo()) {
                return false;
            }
            return this.getAction() != 2;
        }

        boolean isFieldInfo() {
            return this.fMember instanceof IField;
        }

        boolean isNewMethodToBeDeclaredAbstract() throws JavaModelException {
            return !this.isFieldInfo() && !JdtFlags.isAbstract(this.fMember) && this.fAction == 1;
        }

        boolean isToBeCreatedInSubclassesOfDeclaringClass() {
            return this.fAction != 2;
        }

        boolean isToBeDeletedFromDeclaringClass() {
            return this.isToBePushedDown();
        }

        public boolean isToBePushedDown() {
            return this.fAction == 0;
        }

        public void setAction(int action) {
            MemberActionInfo.assertValidAction(this.fMember, action);
            if (this.isFieldInfo()) {
                Assert.isTrue((action != 1 ? 1 : 0) != 0);
            }
            this.fAction = action;
        }
    }

    public static class MemberVisitor
    extends ASTVisitor {
        private final ITypeHierarchy fDeclaringTypeHierarchy;
        private final IType fDeclaringType;
        private final IType[] fDestinationTypes;
        private final ASTRewrite fRewrite;

        public MemberVisitor(ASTRewrite rewrite, IType declaringType, ITypeHierarchy declaringTypeHierarchy, IType[] destinationTypes) {
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)declaringTypeHierarchy);
            Assert.isNotNull((Object)declaringType);
            Assert.isNotNull((Object)destinationTypes);
            this.fRewrite = rewrite;
            this.fDeclaringTypeHierarchy = declaringTypeHierarchy;
            this.fDeclaringType = declaringType;
            this.fDestinationTypes = destinationTypes;
        }

        public final boolean visit(SimpleName node) {
            ITypeBinding typeBinding;
            IVariableBinding varBinding;
            IBinding nodeBinding;
            if (node.getLocationInParent() != MethodInvocation.NAME_PROPERTY && node.getLocationInParent() != FieldAccess.NAME_PROPERTY && (nodeBinding = node.resolveBinding()) instanceof IVariableBinding && (varBinding = (IVariableBinding)nodeBinding).isField() && (typeBinding = varBinding.getDeclaringClass()) != null && !typeBinding.getQualifiedName().equals(this.fDeclaringType.getFullyQualifiedName())) {
                boolean mayNeedSuper = false;
                IType[] iTypeArray = this.fDestinationTypes;
                int n = this.fDestinationTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType destinationType = iTypeArray[n2];
                    try {
                        IField[] fields;
                        IField[] iFieldArray = fields = destinationType.getFields();
                        int n3 = fields.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IField field = iFieldArray[n4];
                            if (field.getElementName().equals(node.getFullyQualifiedName())) {
                                mayNeedSuper = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    ++n2;
                }
                if (mayNeedSuper) {
                    IType[] superTypes;
                    IType[] iTypeArray2 = superTypes = this.fDeclaringTypeHierarchy.getAllSuperclasses(this.fDeclaringType);
                    int n5 = superTypes.length;
                    n = 0;
                    while (n < n5) {
                        IType superType = iTypeArray2[n];
                        if (superType.getFullyQualifiedName().equals(typeBinding.getQualifiedName())) {
                            AST ast = this.fRewrite.getAST();
                            SuperFieldAccess superFieldAccess = ast.newSuperFieldAccess();
                            superFieldAccess.setName(ast.newSimpleName(node.getFullyQualifiedName()));
                            this.fRewrite.replace((ASTNode)node, (ASTNode)superFieldAccess, null);
                            return true;
                        }
                        ++n;
                    }
                }
            }
            return true;
        }

        public final boolean visit(MethodInvocation node) {
            ITypeBinding typeBinding;
            IMethodBinding methodBinding;
            Expression exp = node.getExpression();
            if (exp == null && (methodBinding = node.resolveMethodBinding()) != null && (typeBinding = methodBinding.getDeclaringClass()) != null && !typeBinding.getQualifiedName().equals(this.fDeclaringType.getFullyQualifiedName())) {
                boolean mayNeedSuper = false;
                IType[] iTypeArray = this.fDestinationTypes;
                int n = this.fDestinationTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType destinationType = iTypeArray[n2];
                    try {
                        IMethod[] methods;
                        IMethod[] iMethodArray = methods = destinationType.getMethods();
                        int n3 = methods.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMethod method = iMethodArray[n4];
                            if (method.getElementName().equals(node.getName().getFullyQualifiedName()) && method.getNumberOfParameters() == node.arguments().size()) {
                                mayNeedSuper = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    ++n2;
                }
                if (mayNeedSuper) {
                    IType[] superTypes;
                    IType[] iTypeArray2 = superTypes = this.fDeclaringTypeHierarchy.getAllSuperclasses(this.fDeclaringType);
                    int n5 = superTypes.length;
                    n = 0;
                    while (n < n5) {
                        IType superType = iTypeArray2[n];
                        if (superType.getFullyQualifiedName().equals(typeBinding.getQualifiedName())) {
                            ListRewrite args;
                            List originalArgsList;
                            AST ast = this.fRewrite.getAST();
                            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
                            superMethodInvocation.setName(ast.newSimpleName(node.getName().getFullyQualifiedName()));
                            ListRewrite typeArgs = this.fRewrite.getListRewrite((ASTNode)node, MethodInvocation.TYPE_ARGUMENTS_PROPERTY);
                            List originalTypeList = typeArgs.getOriginalList();
                            if (originalTypeList.size() > 0) {
                                ASTNode typeArgsCopy = typeArgs.createCopyTarget((ASTNode)originalTypeList.get(0), (ASTNode)originalTypeList.get(originalTypeList.size() - 1));
                                superMethodInvocation.typeArguments().add(typeArgsCopy);
                            }
                            if ((originalArgsList = (args = this.fRewrite.getListRewrite((ASTNode)node, MethodInvocation.ARGUMENTS_PROPERTY)).getOriginalList()).size() > 0) {
                                ASTNode argsCopy = typeArgs.createCopyTarget((ASTNode)originalArgsList.get(0), (ASTNode)originalArgsList.get(originalArgsList.size() - 1));
                                superMethodInvocation.arguments().add(argsCopy);
                            }
                            this.fRewrite.replace((ASTNode)node, (ASTNode)superMethodInvocation, null);
                            return true;
                        }
                        ++n;
                    }
                }
            }
            return true;
        }
    }

    public static class ThisVisitor
    extends ASTVisitor {
        private final IType fDeclaringType;
        private final ASTRewrite fRewrite;

        public ThisVisitor(ASTRewrite rewrite, IType declaringType) {
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)declaringType);
            this.fRewrite = rewrite;
            this.fDeclaringType = declaringType;
        }

        public final boolean visit(ThisExpression node) {
            Name q = node.getQualifier();
            if (q == null) {
                return false;
            }
            String qName = q.getFullyQualifiedName();
            if (qName.equals(this.fDeclaringType.getElementName()) || qName.equals(this.fDeclaringType.getFullyQualifiedName())) {
                this.fRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)ThisExpression.QUALIFIER_PROPERTY, null, null);
            }
            return false;
        }
    }
}

