/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.build.service.docker.auth.CredentialHelperClient;
import org.eclipse.jkube.kit.build.service.docker.auth.ecr.EcrExtendedAuth;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class AuthConfigFactory {
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_EMAIL = "email";
    private static final String AUTH_AUTHTOKEN = "authToken";
    private static final String AUTH_USE_OPENSHIFT_AUTH = "useOpenShiftAuth";
    private static final String DOCKER_LOGIN_DEFAULT_REGISTRY = "https://index.docker.io/v1/";
    private final KitLogger log;
    private static final String[] DEFAULT_REGISTRIES = new String[]{"docker.io", "index.docker.io", "registry.hub.docker.com"};

    public AuthConfigFactory(KitLogger log) {
        this.log = log;
    }

    public AuthConfig createAuthConfig(boolean isPush, boolean skipExtendedAuth, Map authConfig, List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod) throws IOException {
        AuthConfig ret = AuthConfigFactory.createStandardAuthConfig(isPush, authConfig, settings, user, registry, passwordDecryptionMethod, this.log);
        if (ret != null) {
            if (registry == null || skipExtendedAuth) {
                return ret;
            }
            try {
                return this.extendedAuthentication(ret, registry);
            }
            catch (IOException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        ret = AuthConfigFactory.getAuthConfigFromDockerConfig(registry, this.log);
        if (ret != null) {
            this.log.debug("AuthConfig: credentials from ~/.docker/config.json", new Object[0]);
            return ret;
        }
        this.log.debug("AuthConfig: no credentials found", new Object[0]);
        return null;
    }

    private AuthConfig extendedAuthentication(AuthConfig standardAuthConfig, String registry) throws IOException {
        EcrExtendedAuth ecr = new EcrExtendedAuth(this.log, registry);
        if (ecr.isAwsRegistry()) {
            return ecr.extendedAuth(standardAuthConfig);
        }
        return standardAuthConfig;
    }

    private static AuthConfig createStandardAuthConfig(boolean isPush, Map authConfigMap, List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod, KitLogger log) throws IOException {
        AuthConfig ret;
        for (LookupMode lookupMode : new LookupMode[]{AuthConfigFactory.getLookupMode(isPush), LookupMode.DEFAULT}) {
            ret = AuthConfigFactory.getAuthConfigFromSystemProperties(lookupMode, passwordDecryptionMethod);
            if (ret != null) {
                log.debug("AuthConfig: credentials from system properties", new Object[0]);
                return ret;
            }
            ret = AuthConfigFactory.getAuthConfigFromOpenShiftConfig(lookupMode, authConfigMap);
            if (ret != null) {
                log.debug("AuthConfig: OpenShift credentials", new Object[0]);
                return ret;
            }
            ret = AuthConfigFactory.getAuthConfigFromPluginConfiguration(lookupMode, authConfigMap, passwordDecryptionMethod);
            if (ret == null) continue;
            log.debug("AuthConfig: credentials from plugin config", new Object[0]);
            return ret;
        }
        ret = AuthConfigFactory.getAuthConfigFromSettings(settings, user, registry, passwordDecryptionMethod);
        if (ret != null) {
            log.debug("AuthConfig: credentials from ~/.m2/setting.xml", new Object[0]);
            return ret;
        }
        if (EcrExtendedAuth.isAwsRegistry(registry)) {
            try {
                ret = AuthConfigFactory.getAuthConfigFromEC2InstanceRole(log);
            }
            catch (ConnectTimeoutException ex) {
                log.debug("Connection timeout while retrieving instance meta-data, likely not an EC2 instance (%s)", new Object[]{ex.getMessage()});
            }
            catch (IOException ex) {
                log.warn("Error while retrieving EC2 instance credentials: %s", new Object[]{ex.getMessage()});
            }
            if (ret != null) {
                log.debug("AuthConfig: credentials from EC2 instance role", new Object[0]);
                return ret;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static AuthConfig getAuthConfigFromEC2InstanceRole(KitLogger log) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[TRYBLOCK]], but top level block is 18[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static AuthConfig getAuthConfigFromSystemProperties(LookupMode lookupMode, UnaryOperator<String> passwordDecryptionMethod) throws IOException {
        String passwordKey = lookupMode.asSysProperty(AUTH_PASSWORD);
        String username = System.getProperty(lookupMode.asSysProperty(AUTH_USERNAME));
        String password = System.getProperty(passwordKey);
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
            throw new IOException("No " + passwordKey + " provided for username " + username);
        }
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            return new AuthConfig(username, (String)passwordDecryptionMethod.apply(password), System.getProperty(lookupMode.asSysProperty(AUTH_EMAIL)), System.getProperty(lookupMode.asSysProperty(AUTH_AUTHTOKEN)));
        }
        return null;
    }

    protected static AuthConfig getAuthConfigFromOpenShiftConfig(LookupMode lookupMode, Map authConfigMap) {
        String useOpenAuthModeKey = lookupMode.asSysProperty(AUTH_USE_OPENSHIFT_AUTH);
        String useOpenAuthMode = System.getProperty(useOpenAuthModeKey);
        if (StringUtils.isNotBlank((CharSequence)useOpenAuthMode)) {
            boolean useOpenShift = Boolean.parseBoolean(useOpenAuthMode);
            if (useOpenShift) {
                return AuthConfigFactory.validateMandatoryOpenShiftLogin(AuthConfigFactory.parseOpenShiftConfig(), useOpenAuthModeKey);
            }
            return null;
        }
        Map<String, String> mapToCheck = AuthConfigFactory.getAuthConfigMapToCheck(lookupMode, authConfigMap);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USE_OPENSHIFT_AUTH) && Boolean.parseBoolean(mapToCheck.get(AUTH_USE_OPENSHIFT_AUTH))) {
            return AuthConfigFactory.validateMandatoryOpenShiftLogin(AuthConfigFactory.parseOpenShiftConfig(), useOpenAuthModeKey);
        }
        return null;
    }

    protected static AuthConfig getAuthConfigFromPluginConfiguration(LookupMode lookupMode, Map<String, ?> authConfig, UnaryOperator<String> passwordDecryptionMethod) {
        Map<String, String> mapToCheck = AuthConfigFactory.getAuthConfigMapToCheck(lookupMode, authConfig);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USERNAME)) {
            if (!mapToCheck.containsKey(AUTH_PASSWORD)) {
                throw new IllegalStateException("No 'password' given while using <authConfig> in configuration for mode " + (Object)((Object)lookupMode));
            }
            HashMap<String, String> cloneConfig = new HashMap<String, String>(mapToCheck);
            cloneConfig.put(AUTH_PASSWORD, (String)passwordDecryptionMethod.apply((String)cloneConfig.get(AUTH_PASSWORD)));
            return AuthConfig.fromMap(cloneConfig);
        }
        return null;
    }

    protected static AuthConfig getAuthConfigFromSettings(List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod) {
        RegistryServerConfiguration defaultServer = null;
        for (RegistryServerConfiguration server : settings) {
            RegistryServerConfiguration found;
            String id = server.getId();
            if (defaultServer == null) {
                defaultServer = AuthConfigFactory.checkForServer(server, id, registry, null);
            }
            if ((found = AuthConfigFactory.checkForServer(server, id, registry, user)) == null) continue;
            return AuthConfigFactory.createAuthConfigFromServer(found, passwordDecryptionMethod);
        }
        return defaultServer != null ? AuthConfigFactory.createAuthConfigFromServer(defaultServer, passwordDecryptionMethod) : null;
    }

    protected static AuthConfig getAuthConfigFromDockerConfig(String registry, KitLogger log) throws IOException {
        String registryToLookup;
        JsonObject dockerConfig = DockerFileUtil.readDockerConfig();
        if (dockerConfig == null) {
            return null;
        }
        String string = registryToLookup = registry != null ? registry : DOCKER_LOGIN_DEFAULT_REGISTRY;
        if (dockerConfig.has("credHelpers") || dockerConfig.has("credsStore")) {
            JsonObject credHelpers;
            if (dockerConfig.has("credHelpers") && (credHelpers = dockerConfig.getAsJsonObject("credHelpers")).has(registryToLookup)) {
                return AuthConfigFactory.extractAuthConfigFromCredentialsHelper(registryToLookup, credHelpers.get(registryToLookup).getAsString(), log);
            }
            if (dockerConfig.has("credsStore")) {
                return AuthConfigFactory.extractAuthConfigFromCredentialsHelper(registryToLookup, dockerConfig.get("credsStore").getAsString(), log);
            }
        }
        if (dockerConfig.has("auths")) {
            return AuthConfigFactory.extractAuthConfigFromAuths(registryToLookup, dockerConfig.getAsJsonObject("auths"));
        }
        return null;
    }

    private static AuthConfig extractAuthConfigFromAuths(String registryToLookup, JsonObject auths) {
        JsonObject credentials = AuthConfigFactory.getCredentialsNode(auths, registryToLookup);
        if (credentials == null || !credentials.has("auth")) {
            return null;
        }
        String auth = credentials.get("auth").getAsString();
        String email = credentials.has(AUTH_EMAIL) ? credentials.get(AUTH_EMAIL).getAsString() : null;
        return AuthConfig.fromCredentialsEncoded((String)auth, (String)email);
    }

    private static AuthConfig extractAuthConfigFromCredentialsHelper(String registryToLookup, String credConfig, KitLogger log) throws IOException {
        CredentialHelperClient credentialHelper = new CredentialHelperClient(log, credConfig);
        String version = credentialHelper.getVersion();
        log.debug("AuthConfig: credentials from credential helper/store %s%s", new Object[]{credentialHelper.getName(), version != null ? " version " + version : ""});
        return credentialHelper.getAuthConfig(registryToLookup);
    }

    private static JsonObject getCredentialsNode(JsonObject auths, String registryToLookup) {
        if (auths.has(registryToLookup)) {
            return auths.getAsJsonObject(registryToLookup);
        }
        String registryWithScheme = EnvUtil.ensureRegistryHttpUrl((String)registryToLookup);
        if (auths.has(registryWithScheme)) {
            return auths.getAsJsonObject(registryWithScheme);
        }
        return null;
    }

    private static Map<String, String> getAuthConfigMapToCheck(LookupMode lookupMode, Map<?, ?> authConfigMap) {
        String configMapKey = lookupMode.getConfigMapKey();
        if (configMapKey == null) {
            return authConfigMap;
        }
        if (authConfigMap != null) {
            return (Map)((Object)authConfigMap.get(configMapKey));
        }
        return null;
    }

    private static AuthConfig parseOpenShiftConfig() {
        Map kubeConfig = DockerFileUtil.readKubeConfig();
        if (kubeConfig == null) {
            return null;
        }
        String currentContextName = (String)kubeConfig.get("current-context");
        if (currentContextName == null) {
            return null;
        }
        for (Map contextMap : (List)kubeConfig.get("contexts")) {
            if (!currentContextName.equals(contextMap.get("name"))) continue;
            return AuthConfigFactory.parseContext(kubeConfig, (Map)contextMap.get("context"));
        }
        return null;
    }

    private static AuthConfig parseContext(Map kubeConfig, Map context) {
        if (context == null) {
            return null;
        }
        String userName = (String)context.get("user");
        if (userName == null) {
            return null;
        }
        List users = (List)kubeConfig.get("users");
        if (users == null) {
            return null;
        }
        for (Map userMap : users) {
            if (!userName.equals(userMap.get("name"))) continue;
            return AuthConfigFactory.parseUser(userName, (Map)userMap.get("user"));
        }
        return null;
    }

    private static AuthConfig parseUser(String userName, Map user) {
        if (user == null) {
            return null;
        }
        String token = (String)user.get("token");
        if (token == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("^([^/]+).*$").matcher(userName);
        return new AuthConfig(matcher.matches() ? matcher.group(1) : userName, token, null, null);
    }

    private static AuthConfig validateMandatoryOpenShiftLogin(AuthConfig openShiftAuthConfig, String useOpenAuthModeProp) {
        if (openShiftAuthConfig != null) {
            return openShiftAuthConfig;
        }
        String kubeConfigEnv = System.getenv("KUBECONFIG");
        throw new IllegalStateException(String.format("System property %s set, but not active user and/or token found in %s. Please use 'oc login' for connecting to OpenShift.", useOpenAuthModeProp, kubeConfigEnv != null ? kubeConfigEnv : "~/.kube/config"));
    }

    private static RegistryServerConfiguration checkForServer(RegistryServerConfiguration server, String id, String registry, String user) {
        String[] registries;
        String[] stringArray;
        if (registry != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = registry;
        } else {
            stringArray = DEFAULT_REGISTRIES;
        }
        for (String reg : registries = stringArray) {
            if (!id.equals(user == null ? reg : reg + "/" + user)) continue;
            return server;
        }
        return null;
    }

    private static AuthConfig createAuthConfigFromServer(RegistryServerConfiguration server, UnaryOperator<String> passwordDecryptionMethod) {
        return new AuthConfig(server.getUsername(), (String)passwordDecryptionMethod.apply(server.getPassword()), AuthConfigFactory.extractFromServerConfiguration(server.getConfiguration(), AUTH_EMAIL), AuthConfigFactory.extractFromServerConfiguration(server.getConfiguration(), "auth"));
    }

    private static String extractFromServerConfiguration(Map<String, Object> configuration, String prop) {
        if (configuration != null && configuration.containsKey(prop)) {
            return configuration.get(prop).toString();
        }
        return null;
    }

    private static LookupMode getLookupMode(boolean isPush) {
        return isPush ? LookupMode.PUSH : LookupMode.PULL;
    }

    protected static enum LookupMode {
        PUSH("jkube.docker.push.", "push"),
        PULL("jkube.docker.pull.", "pull"),
        DEFAULT("jkube.docker.", null);

        private final String sysPropPrefix;
        private String configMapKey;

        private LookupMode(String sysPropPrefix, String configMapKey) {
            this.sysPropPrefix = sysPropPrefix;
            this.configMapKey = configMapKey;
        }

        public String asSysProperty(String prop) {
            return this.sysPropPrefix + prop;
        }

        public String getConfigMapKey() {
            return this.configMapKey;
        }
    }
}

