/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.GeneratorManager;
import org.eclipse.jkube.kit.build.core.GavLabel;
import org.eclipse.jkube.kit.build.service.docker.DockerAccessFactory;
import org.eclipse.jkube.kit.build.service.docker.DockerServiceHub;
import org.eclipse.jkube.kit.build.service.docker.ImagePullManager;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogDispatcher;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpecFactory;
import org.eclipse.jkube.kit.build.service.docker.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.build.service.docker.config.DockerMachineConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ImageConfigResolver;
import org.eclipse.jkube.kit.build.service.docker.helper.ConfigHelper;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.util.AnsiLogger;
import org.eclipse.jkube.kit.common.util.BuildReferenceDateUtil;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.access.ClusterConfiguration;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.WatchMode;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.image.build.RegistryAuthConfiguration;
import org.eclipse.jkube.kit.config.resource.BuildRecreateMode;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;
import org.eclipse.jkube.kit.enricher.api.DefaultEnricherManager;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.profile.ProfileUtil;
import org.eclipse.jkube.maven.plugin.mojo.KitLoggerProvider;
import org.fusesource.jansi.Ansi;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public abstract class AbstractDockerMojo
extends AbstractMojo
implements ConfigHelper.Customizer,
Contextualizable,
KitLoggerProvider {
    public static final String CONTEXT_KEY_LOG_DISPATCHER = "CONTEXT_KEY_DOCKER_LOG_DISPATCHER";
    public static final String CONTEXT_KEY_BUILD_TIMESTAMP = "CONTEXT_KEY_BUILD_TIMESTAMP";
    public static final String DOCKER_BUILD_TIMESTAMP = "docker/build.timestamp";
    @Parameter
    protected ClusterConfiguration access;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    protected MojoExecution mojoExecution;
    @Parameter(property="jkube.docker.verbose", defaultValue="false")
    protected String verbose;
    @Parameter(property="jkube.docker.logDate")
    protected String logDate;
    @Parameter(property="jkube.docker.logStdout", defaultValue="false")
    protected boolean logStdout;
    @Parameter(property="jkube.docker.host")
    protected String dockerHost;
    @Parameter(property="jkube.docker.certPath")
    protected String certPath;
    @Parameter
    protected DockerMachineConfiguration machine;
    @Parameter(property="jkube.docker.skip.machine", defaultValue="false")
    protected boolean skipMachine;
    @Parameter(property="jkube.docker.maxConnections", defaultValue="100")
    protected int maxConnections;
    @Parameter(property="jkube.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="jkube.image.filter")
    protected String filter;
    protected List<ImageConfiguration> resolvedImages;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="jkube.build.source.dir", defaultValue="src/main/docker")
    protected String sourceDirectory;
    @Parameter(property="jkube.build.target.dir", defaultValue="target/docker")
    protected String outputDirectory;
    @Parameter(property="jkube.docker.autoPull")
    protected String autoPull;
    @Parameter(property="jkube.docker.imagePullPolicy")
    protected String imagePullPolicy;
    @Parameter(property="jkube.docker.pull.registry")
    protected String pullRegistry;
    @Parameter(property="jkube.build.strategy")
    protected JKubeBuildStrategy buildStrategy;
    @Parameter(property="jkube.profile")
    protected String profile;
    @Component
    protected ImageConfigResolver imageConfigResolver;
    @Parameter(property="jkube.docker.skip.extendedAuth", defaultValue="false")
    protected boolean skipExtendedAuth;
    @Parameter
    protected Map<String, String> buildArgs;
    @Parameter
    protected RegistryAuthConfiguration authConfig;
    @Parameter(property="jkube.docker.registry")
    protected String registry;
    @Parameter(property="jkube.build.recreate", defaultValue="none")
    protected String buildRecreate;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected DockerAccessFactory dockerAccessFactory;
    @Parameter
    protected List<ImageConfiguration> images;
    @Parameter(property="jkube.skip.build", defaultValue="false")
    protected boolean skipBuild;
    @Parameter(property="jkube.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="jkube.skip.build.pom")
    protected Boolean skipBuildPom;
    @Parameter
    protected ProcessorConfig generator;
    @Parameter(property="jkube.build.forcePull", defaultValue="false")
    protected boolean forcePull = false;
    @Parameter(property="jkube.useProjectClasspath", defaultValue="false")
    protected boolean useProjectClasspath = false;
    @Parameter
    protected ResourceConfig resources;
    @Parameter
    protected ProcessorConfig enricher;
    @Parameter(property="jkube.resourceDir", defaultValue="${basedir}/src/main/jkube")
    protected File resourceDir;
    @Parameter(property="jkube.environment")
    protected String environment;
    protected AuthConfigFactory authConfigFactory;
    protected KitLogger log;
    protected LogOutputSpecFactory logOutputSpecFactory;
    protected ClusterAccess clusterAccess;
    protected JKubeServiceHub jkubeServiceHub;
    protected RuntimeMode runtimeMode;
    protected PlexusContainer plexusContainer;
    @Parameter(property="jkube.watch.mode", defaultValue="both")
    protected WatchMode watchMode;
    @Parameter(property="jkube.watch.interval", defaultValue="5000")
    protected int watchInterval;
    @Parameter(property="jkube.watch.keepRunning", defaultValue="false")
    protected boolean keepRunning;
    @Parameter(property="jkube.watch.postGoal")
    protected String watchPostGoal;
    @Parameter(property="jkube.watch.postExec")
    protected String watchPostExec;
    @Parameter(property="jkube.watch.keepContainer", defaultValue="false")
    protected boolean keepContainer;
    @Parameter(property="jkube.watch.removeVolumes", defaultValue="false")
    protected boolean removeVolumes;
    @Parameter(property="jkube.watch.follow", defaultValue="false")
    protected boolean watchFollow;
    @Parameter(property="jkube.watch.showLogs")
    protected String watchShowLogs;
    @Parameter(property="jkube.watch.containerNamePattern")
    protected String containerNamePattern = "%n-%i";
    @Parameter(property="jkube.namespace")
    protected String namespace;
    @Parameter(property="jkube.watch.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;
    @Parameter(property="jkube.offline", defaultValue="false")
    protected boolean offline;
    protected JavaProject javaProject;

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    @Override
    public KitLogger getKitLogger() {
        return this.log;
    }

    public RuntimeMode getConfiguredRuntimeMode() {
        return RuntimeMode.KUBERNETES;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        if (this.shouldSkip()) {
            this.log.info("`%s` goal is skipped.", new Object[]{this.mojoExecution.getMojoDescriptor().getFullGoalName()});
            return;
        }
        this.doExecute();
    }

    protected void init() {
        this.log = new AnsiLogger(this.getLog(), this.useColorForLogging(), this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix());
        this.logOutputSpecFactory = new LogOutputSpecFactory(this.useColorForLogging(), this.logStdout, this.logDate);
        this.authConfigFactory = new AuthConfigFactory(this.log);
        this.imageConfigResolver.setLog(this.log);
        this.clusterAccess = new ClusterAccess(this.initClusterConfiguration());
        this.runtimeMode = this.getConfiguredRuntimeMode();
    }

    protected boolean shouldSkip() {
        return this.skip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws MojoExecutionException {
        boolean ansiRestore = Ansi.isEnabled();
        try {
            DockerAccess dockerAccess = null;
            try {
                this.javaProject = MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session);
                this.resources = KubernetesClientUtil.updateResourceConfigNamespace((String)this.namespace, (ResourceConfig)this.resources);
                if (this.isDockerAccessRequired()) {
                    DockerAccessFactory.DockerAccessContext dockerAccessContext = this.getDockerAccessContext();
                    dockerAccess = this.dockerAccessFactory.createDockerAccess(dockerAccessContext);
                }
                this.jkubeServiceHub = JKubeServiceHub.builder().log(this.log).configuration(this.initJKubeConfiguration()).clusterAccess(this.clusterAccess).platformMode(this.getConfiguredRuntimeMode()).dockerServiceHub(DockerServiceHub.newInstance((KitLogger)this.log, (DockerAccess)dockerAccess, (LogOutputSpecFactory)this.logOutputSpecFactory)).buildServiceConfig(this.buildServiceConfigBuilder().build()).offline(this.offline).build();
                this.resolvedImages = ConfigHelper.initImageConfiguration((Date)BuildReferenceDateUtil.getBuildTimestamp((Map)this.getPluginContext(), (String)CONTEXT_KEY_BUILD_TIMESTAMP, (String)this.project.getBuild().getDirectory(), (String)DOCKER_BUILD_TIMESTAMP), this.images, (ImageConfigResolver)this.imageConfigResolver, (KitLogger)this.log, (String)this.filter, (ConfigHelper.Customizer)this, (JKubeConfiguration)this.jkubeServiceHub.getConfiguration());
                this.executeInternal();
            }
            catch (IOException | DependencyResolutionRequiredException exp) {
                this.logException((Exception)exp);
                throw new MojoExecutionException(exp.getMessage());
            }
            catch (MojoExecutionException exp) {
                this.logException((Exception)((Object)exp));
                throw exp;
            }
            finally {
                Optional.ofNullable(this.jkubeServiceHub).ifPresent(JKubeServiceHub::close);
            }
        }
        finally {
            Ansi.setEnabled((boolean)ansiRestore);
        }
    }

    protected abstract void executeInternal() throws IOException, MojoExecutionException;

    protected JKubeConfiguration initJKubeConfiguration() throws DependencyResolutionRequiredException {
        ConfigHelper.validateExternalPropertyActivation((JavaProject)this.javaProject, this.images);
        return JKubeConfiguration.builder().project(MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session)).sourceDirectory(this.sourceDirectory).outputDirectory(this.outputDirectory).reactorProjects(Collections.singletonList(this.javaProject)).buildArgs(this.buildArgs).registryConfig(this.getRegistryConfig(this.pullRegistry)).build();
    }

    protected RegistryConfig getRegistryConfig(String specificRegistry) {
        return RegistryConfig.builder().settings(MavenUtil.getRegistryServerFromMavenSettings((Settings)this.settings)).authConfig(this.authConfig != null ? this.authConfig.toMap() : null).skipExtendedAuth(this.skipExtendedAuth).registry(specificRegistry != null ? specificRegistry : this.registry).passwordDecryptionMethod(password -> {
            try {
                if (this.plexusContainer != null) {
                    Object secDispatcher = this.plexusContainer.lookup(SecDispatcher.ROLE, "maven");
                    Method method = secDispatcher.getClass().getMethod("decrypt", String.class);
                    return (String)method.invoke(secDispatcher, password);
                }
                return password;
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Error looking security dispatcher", e);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Cannot decrypt password: " + e.getCause(), e);
            }
        }).build();
    }

    protected void logException(Exception exp) {
        if (exp.getCause() != null) {
            this.log.error("%s [%s]", new Object[]{exp.getMessage(), exp.getCause().getMessage()});
        } else {
            this.log.error("%s", new Object[]{exp.getMessage()});
        }
    }

    protected DockerAccessFactory.DockerAccessContext getDockerAccessContext() {
        return DockerAccessFactory.DockerAccessContext.builder().dockerHost(this.dockerHost).certPath(this.certPath).machine(this.machine).maxConnections(this.maxConnections).projectProperties(this.project.getProperties()).skipMachine(this.skipMachine).log(this.log).build();
    }

    protected List<ImageConfiguration> getResolvedImages() {
        return this.resolvedImages;
    }

    protected boolean isDockerAccessRequired() {
        return !this.getJKubeBuildStrategy().equals((Object)JKubeBuildStrategy.jib);
    }

    void executeBuildGoal() throws MojoExecutionException {
        if (this.skipBuild) {
            return;
        }
        this.buildAndTag(this.getResolvedImages());
    }

    protected boolean shouldSkipBecauseOfPomPackaging() {
        if (!this.project.getPackaging().equals("pom")) {
            return false;
        }
        if (this.skipBuildPom != null) {
            return this.skipBuildPom;
        }
        for (ImageConfiguration image : this.getResolvedImages()) {
            if (image.getBuildConfiguration() == null) continue;
            return false;
        }
        return true;
    }

    private void buildAndTag(List<ImageConfiguration> imageConfigs) throws MojoExecutionException {
        try {
            EnvUtil.storeTimestamp((File)BuildReferenceDateUtil.getBuildTimestampFile((String)this.project.getBuild().getDirectory(), (String)DOCKER_BUILD_TIMESTAMP), (Date)BuildReferenceDateUtil.getBuildTimestamp((Map)this.getPluginContext(), (String)CONTEXT_KEY_BUILD_TIMESTAMP, (String)this.project.getBuild().getDirectory(), (String)DOCKER_BUILD_TIMESTAMP));
            this.jkubeServiceHub.getBuildService().build(imageConfigs.toArray(new ImageConfiguration[0]));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to execute the build", ex);
        }
    }

    protected BuildServiceConfig.BuildServiceConfigBuilder buildServiceConfigBuilder() {
        return BuildServiceConfig.builder().buildRecreateMode(BuildRecreateMode.fromParameter((String)this.buildRecreate)).jKubeBuildStrategy(this.getJKubeBuildStrategy()).forcePull(this.forcePull).imagePullManager(ImagePullManager.createImagePullManager((String)this.imagePullPolicy, (String)this.autoPull, (Properties)this.project.getProperties())).buildDirectory(this.project.getBuild().getDirectory()).resourceConfig(this.resources).resourceDir(this.resourceDir).attacher((classifier, destFile) -> {
            if (destFile.exists()) {
                this.projectHelper.attachArtifact(this.project, "yml", classifier, destFile);
            }
        }).enricherTask(builder -> {
            DefaultEnricherManager enricherManager = new DefaultEnricherManager(this.getEnricherContext(), this.useProjectClasspath ? this.javaProject.getCompileClassPathElements() : Collections.emptyList());
            enricherManager.enrich(PlatformMode.kubernetes, builder);
            enricherManager.enrich(PlatformMode.openshift, builder);
        });
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        this.log.info("Building Docker image", new Object[0]);
        try {
            return GeneratorManager.generate(configs, (GeneratorContext)this.generatorContextBuilder().build(), (boolean)false);
        }
        catch (DependencyResolutionRequiredException de) {
            throw new IllegalArgumentException("Instructed to use project classpath, but cannot. Continuing build if we can: ", de);
        }
    }

    protected String getLogPrefix() {
        return "k8s: ";
    }

    protected JKubeBuildStrategy getJKubeBuildStrategy() {
        if (this.buildStrategy != null) {
            return this.buildStrategy;
        }
        return JKubeBuildStrategy.docker;
    }

    public EnricherContext getEnricherContext() throws DependencyResolutionRequiredException {
        return JKubeEnricherContext.builder().project(MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session)).processorConfig(this.extractEnricherConfig()).images(this.getResolvedImages()).resources(this.resources).log(this.log).build();
    }

    protected GeneratorContext.GeneratorContextBuilder generatorContextBuilder() throws DependencyResolutionRequiredException {
        return GeneratorContext.builder().config(this.extractGeneratorConfig()).project(MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session)).logger(this.log).runtimeMode(this.runtimeMode).useProjectClasspath(this.useProjectClasspath);
    }

    protected ProcessorConfig extractGeneratorConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (List)ResourceUtil.getFinalResourceDirs((File)this.resourceDir, (String)this.environment), (ProcessorConfig)this.generator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }

    protected ProcessorConfig extractEnricherConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (List)ResourceUtil.getFinalResourceDirs((File)this.resourceDir, (String)this.environment), (ProcessorConfig)this.enricher);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract enricher config: " + e, e);
        }
    }

    protected boolean useColorForLogging() {
        return this.useColor && MessageUtils.isColorEnabled() && (!EnvUtil.isWindows() || MavenUtil.isMaven350OrLater((MavenSession)this.session));
    }

    protected ClusterConfiguration initClusterConfiguration() {
        return ClusterConfiguration.from((ClusterConfiguration)this.access, (Properties[])new Properties[]{System.getProperties(), this.project.getProperties()}).build();
    }

    protected GavLabel getGavLabel() {
        return new GavLabel(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    protected LogDispatcher getLogDispatcher(DockerServiceHub hub) {
        LogDispatcher dispatcher = (LogDispatcher)this.getPluginContext().get(CONTEXT_KEY_LOG_DISPATCHER);
        if (dispatcher == null) {
            dispatcher = new LogDispatcher(hub.getDockerAccess());
            this.getPluginContext().put(CONTEXT_KEY_LOG_DISPATCHER, dispatcher);
        }
        return dispatcher;
    }
}

