/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmServiceUtil;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class HelmMojo
extends AbstractJKubeMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    File kubernetesManifest;
    @Parameter(property="jkube.kubernetesTemplate", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes")
    File kubernetesTemplate;
    @Parameter
    HelmConfig helm;

    @Override
    public void executeInternal() throws MojoExecutionException {
        try {
            File manifest = this.getKubernetesManifest();
            if (manifest == null || !manifest.isFile()) {
                this.logManifestNotFoundWarning(manifest);
            }
            this.helm = HelmServiceUtil.initHelmConfig((HelmConfig.HelmType)this.getDefaultHelmType(), (JavaProject)this.javaProject, (File)this.getKubernetesManifest(), (File)this.getKubernetesTemplate(), (HelmConfig)this.helm).generatedChartListeners(Collections.singletonList((helmConfig, type, chartFile) -> this.projectHelper.attachArtifact(this.project, helmConfig.getChartExtension(), type.getClassifier(), chartFile))).build();
            this.jkubeServiceHub.getHelmService().generateHelmCharts(this.helm);
        }
        catch (IOException exception) {
            throw new MojoExecutionException(exception.getMessage());
        }
    }

    protected void logManifestNotFoundWarning(File manifest) {
        this.getKitLogger().warn("No kubernetes manifest file has been generated yet by the k8s:resource goal at: " + manifest, new Object[0]);
    }

    protected File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    protected File getKubernetesTemplate() {
        return this.kubernetesTemplate;
    }

    protected HelmConfig.HelmType getDefaultHelmType() {
        return HelmConfig.HelmType.KUBERNETES;
    }

    HelmConfig getHelm() {
        return this.helm;
    }
}

