/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.launcher.Introspection;
import org.polarsys.kitalpha.pdt.introspector.internal.ui.Activator;
import org.polarsys.kitalpha.pdt.introspector.preferences.utils.IntrospectorPreferenceUtils;
import org.polarsys.kitalpha.pdt.introspector.ui.wizard.pages.IntrospectionWizardFirstPage;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class IntrospectorWizard
extends Wizard
implements INewWizard {
    private IFolder selection;
    private IntrospectionContext introContext = Introspection.getIntroContextInstance();
    private IntrospectionWizardFirstPage firstPage;

    public IntrospectorWizard(IFolder selection) {
        this.selection = selection;
        this.setWindowTitle("Eclipse Introspection");
        this.setNeedsProgressMonitor(false);
    }

    public boolean performFinish() {
        this.firstPage = (IntrospectionWizardFirstPage)this.getStartingPage();
        this.introContext.setModelName(this.firstPage.getModelName());
        this.introContext.setFilterRegEx(this.firstPage.getSpecifiedFilterRegex());
        final boolean overridePreferences = this.firstPage.preferencesHaveBeenOverriden();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IntrospectorWizard.this.setUpIntrospectionParameters(overridePreferences, monitor);
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.pdt.introspector.ui", "Error during perform finish", (Throwable)e));
        }
        catch (InterruptedException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.pdt.introspector.ui", "Error during perform finish", (Throwable)e));
        }
        return true;
    }

    private void setUpIncrementalIntrospectionType(boolean overridePreferences) {
        String incrementalIntrospectionType;
        switch (incrementalIntrospectionType = this.firstPage.getIncrementalIntrospectionType()) {
            case "sameFolder": {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIncrementalIntrospectionType((String)"reuseFromFolder");
                    break;
                }
                this.introContext.setIncrementalIntrospection("reuseFromFolder");
                break;
            }
            case "sameWorkspace": {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIncrementalIntrospectionType((String)"reuseFromWorkspace");
                    break;
                }
                this.introContext.setIncrementalIntrospection("reuseFromWorkspace");
                break;
            }
            case "modelreuse": {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIncrementalIntrospectionType((String)"reuseFromResourceReuse");
                } else {
                    this.introContext.setIncrementalIntrospection("reuseFromResourceReuse");
                }
                this.introContext.setCriteria(this.firstPage.getCriteria());
                break;
            }
            default: {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIncrementalIntrospectionType((String)"reuseFromWorkspace");
                    break;
                }
                this.introContext.setIncrementalIntrospection("reuseFromWorkspace");
            }
        }
    }

    private void setUpIntrospectionParameters(boolean overridePreferences, IProgressMonitor monitor) {
        if (overridePreferences) {
            this.setUpIntrospectionPerimeter(true);
            if (this.firstPage.isIncremental()) {
                IntrospectorPreferenceUtils.setIncrementalIntrospectionStatut((boolean)true);
            } else {
                IntrospectorPreferenceUtils.setIncrementalIntrospectionStatut((boolean)false);
            }
            this.setUpIncrementalIntrospectionType(true);
            IntrospectorPreferenceUtils.setCreatePackageSetting((boolean)this.firstPage.createPackages());
            IntrospectorPreferenceUtils.setIntrospectionIssuesStorageStatut((boolean)this.firstPage.storeIntrospectionIssues());
            IntrospectorPreferenceUtils.setQualifierMatchingSetting((boolean)this.firstPage.ignoreQualifier());
            IntrospectorPreferenceUtils.setCriteria((SearchCriteria)this.firstPage.getCriteria());
            Introspection.startIntrospection((IProgressMonitor)monitor, (IFolder)this.selection, (boolean)overridePreferences);
        } else {
            this.introContext.setIntrospectionPerimeter(this.firstPage.getIntrospectionPerimeter());
            this.setUpIntrospectionPerimeter(false);
            this.introContext.setActivateIncrementalIntrospection(this.firstPage.isIncremental());
            this.setUpIncrementalIntrospectionType(false);
            this.introContext.setCreatePackages(this.firstPage.createPackages());
            this.introContext.setStoreIntrospectionIssues(this.firstPage.storeIntrospectionIssues());
            this.introContext.setQualifierMatch(this.firstPage.ignoreQualifier());
            this.introContext.setCriteria(this.firstPage.getCriteria());
            Introspection.startIntrospection((IProgressMonitor)monitor, (IFolder)this.selection, (boolean)overridePreferences);
        }
    }

    private void setUpIntrospectionPerimeter(boolean overridePreferences) {
        String introspectionPerimeter;
        switch (introspectionPerimeter = this.firstPage.getIntrospectionPerimeter()) {
            case "platform": {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIntrospectionPerimeter((String)"platformOnly");
                    break;
                }
                this.introContext.setIntrospectionPerimeter("platformOnly");
                break;
            }
            case "workspace": {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIntrospectionPerimeter((String)"workspaceOnly");
                    break;
                }
                this.introContext.setIntrospectionPerimeter("workspaceOnly");
                break;
            }
            case "both": {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIntrospectionPerimeter((String)"platformAndWorkspace");
                    break;
                }
                this.introContext.setIntrospectionPerimeter("platformAndWorkspace");
                break;
            }
            default: {
                if (overridePreferences) {
                    IntrospectorPreferenceUtils.setIntrospectionPerimeter((String)"platformOnly");
                    break;
                }
                this.introContext.setIntrospectionPerimeter("platformOnly");
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Display display = workbench.getDisplay();
        WizardDialog wizardDialog = new WizardDialog(display.getActiveShell(), (IWizard)this);
        wizardDialog.open();
    }
}

