/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.services;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.schema.SchemaRootElement;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.ExtensionPointsComparator;
import org.polarsys.kitalpha.pdt.introspector.core.services.Helpers;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ComplexCompositor;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ComplexCompositorKind;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttribute;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttributeKind;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ExtensionPoint;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformFactory;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.SchemaElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.SchemaElementReference;

public class ExtensionPointServices {
    public static void createSchemaElements(IntrospectionContext introContext, IExtensionPoint currentExtensionPoint, ExtensionPoint extensionPoint) {
        String extensionPointID = currentExtensionPoint.getUniqueIdentifier();
        extensionPoint = introContext.getExtensionPointId_ExtensionPoint().get(extensionPointID);
        SchemaRegistry schemaRegistry = PDECore.getDefault().getSchemaRegistry();
        ISchema currentPluginSchema = schemaRegistry.getSchema(extensionPointID);
        if (currentPluginSchema != null) {
            HashMap<ISchemaElement, SchemaElement> schemaElementHashMap = new HashMap<ISchemaElement, SchemaElement>();
            ExtensionPointServices.createSchemaElements(introContext, extensionPoint, currentPluginSchema, schemaElementHashMap);
        } else {
            String message = "Cannot find any schema element related to this extension point";
            String detail = "Cannot find any schema element related to this extension point.";
            Helpers.createErrorForModelElement((EclipseElement)extensionPoint, introContext, message, detail);
        }
    }

    private static void createSchemaElements(IntrospectionContext introContext, ExtensionPoint extensionPoint, ISchema currentPluginSchema, HashMap<ISchemaElement, SchemaElement> schemaElementHashMap) {
        ISchemaElement iSchemaElement;
        ISchemaElement[] eclipseSchemaElements = currentPluginSchema.getResolvedElements();
        EList schemaElements = extensionPoint.getSchemaElements();
        schemaElementHashMap = introContext.getEclipseSchemaElement_SchemaElement();
        PlatformFactory platformFactory = PlatformFactory.eINSTANCE;
        ISchemaElement[] iSchemaElementArray = eclipseSchemaElements;
        int n = eclipseSchemaElements.length;
        int n2 = 0;
        while (n2 < n) {
            iSchemaElement = iSchemaElementArray[n2];
            ISchemaAttribute[] schemaAttributes = iSchemaElement.getAttributes();
            SchemaElement schemaElement = platformFactory.createSchemaElement();
            ExtensionPointServices.setUpSchemaElementAttribute(platformFactory, schemaElement, schemaAttributes, (EList<SchemaElement>)schemaElements);
            schemaElement.setName(iSchemaElement.getName());
            schemaElements.add((Object)schemaElement);
            if (iSchemaElement instanceof SchemaRootElement) {
                extensionPoint.setExtensionSchemaElement(schemaElement);
            }
            introContext.addSchemaElement(iSchemaElement, schemaElement);
            ++n2;
        }
        iSchemaElementArray = eclipseSchemaElements;
        n = eclipseSchemaElements.length;
        n2 = 0;
        while (n2 < n) {
            iSchemaElement = iSchemaElementArray[n2];
            ExtensionPointServices.setUpComplexCompositor(introContext, platformFactory, iSchemaElement);
            ++n2;
        }
    }

    private static void setUpComplexCompositor(IntrospectionContext introContext, PlatformFactory platformFactory, ISchemaElement iSchemaElement) {
        SchemaComplexType sct;
        ISchemaCompositor compositor;
        if (iSchemaElement.getType() instanceof SchemaComplexType && (compositor = (sct = (SchemaComplexType)iSchemaElement.getType()).getCompositor()) != null) {
            SchemaElement currentSchemaElement = introContext.getEclipseSchemaElement_SchemaElement().get(iSchemaElement);
            ComplexCompositor complexCompositor = platformFactory.createComplexCompositor();
            ExtensionPointServices.setUpComplexCompositorCardinalityAndKind(compositor, complexCompositor);
            ExtensionPointServices.setUpComplexCompositorChildren(introContext, compositor, complexCompositor);
            ISchemaObject[] children = compositor.getChildren();
            if (children.length != 0) {
                ISchemaObject[] iSchemaObjectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ISchemaObject iSchemaObject = iSchemaObjectArray[n2];
                    ExtensionPointServices.setUpComplexCompositorSchemaElementReference(introContext, complexCompositor, iSchemaObject);
                    ++n2;
                }
            }
            currentSchemaElement.setComplexCompositor(complexCompositor);
        }
    }

    private static void setUpComplexCompositorSchemaElementReference(IntrospectionContext introContext, ComplexCompositor complexCompositor, ISchemaObject iSchemaObject) {
        if (iSchemaObject instanceof org.eclipse.pde.internal.core.schema.SchemaElementReference) {
            SchemaElementReference schemaElementReference = PlatformFactory.eINSTANCE.createSchemaElementReference();
            ISchemaElement currentReferencedSchemaElement = ((org.eclipse.pde.internal.core.schema.SchemaElementReference)iSchemaObject).getReferencedElement();
            if (currentReferencedSchemaElement != null) {
                schemaElementReference.setUnbounded(false);
                int maxOccurs = ((org.eclipse.pde.internal.core.schema.SchemaElementReference)iSchemaObject).getMaxOccurs();
                schemaElementReference.setMinCard(currentReferencedSchemaElement.getMinOccurs());
                if (maxOccurs == Integer.MAX_VALUE) {
                    schemaElementReference.setUnbounded(true);
                    schemaElementReference.setMaxCard(maxOccurs);
                } else {
                    schemaElementReference.setMaxCard(maxOccurs);
                }
                HashMap<ISchemaElement, SchemaElement> eclipseSchemaElement_SchemaElement = introContext.getEclipseSchemaElement_SchemaElement();
                SchemaElement referencedSchemaElement = eclipseSchemaElement_SchemaElement.get(currentReferencedSchemaElement);
                schemaElementReference.setReference(referencedSchemaElement);
                schemaElementReference.setName(currentReferencedSchemaElement.getName());
                complexCompositor.getElementReferences().add((Object)schemaElementReference);
            }
        }
    }

    private static void setUpComplexCompositorChildren(IntrospectionContext introContext, ISchemaCompositor currentComplexCompositor2, ComplexCompositor complexCompositor) {
        ISchemaObject[] children;
        if (currentComplexCompositor2 != null && (children = currentComplexCompositor2.getChildren()).length != 0) {
            ISchemaObject[] iSchemaObjectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISchemaObject schemaObject = iSchemaObjectArray[n2];
                if (schemaObject instanceof ISchemaCompositor) {
                    ComplexCompositor complexCompositorChild = PlatformFactory.eINSTANCE.createComplexCompositor();
                    ISchemaCompositor currentComplexCompositor = (ISchemaCompositor)schemaObject;
                    ExtensionPointServices.setUpComplexCompositorCardinalityAndKind(currentComplexCompositor, complexCompositorChild);
                    complexCompositor.getComplexCompositorChildren().add((Object)complexCompositorChild);
                    ExtensionPointServices.setUpComplexCompositorChildren(introContext, currentComplexCompositor, complexCompositorChild);
                }
                ++n2;
            }
        }
    }

    private static void setUpComplexCompositorCardinalityAndKind(ISchemaCompositor currentComplexCompositor, ComplexCompositor complexCompositor) {
        int complexCompositorMinCard = currentComplexCompositor.getMinOccurs();
        int complexCompositorMaxCard = currentComplexCompositor.getMaxOccurs();
        complexCompositor.setUnbounded(false);
        if (complexCompositorMaxCard == Integer.MAX_VALUE) {
            complexCompositor.setUnbounded(true);
            complexCompositor.setMaxCard(complexCompositorMaxCard);
        } else {
            complexCompositor.setMaxCard(complexCompositorMaxCard);
        }
        complexCompositor.setMinCard(complexCompositorMinCard);
        int kind = 0;
        if (currentComplexCompositor != null) {
            kind = currentComplexCompositor.getKind();
        }
        if (currentComplexCompositor != null && (kind == 1 || kind == 2)) {
            switch (kind) {
                case 1: {
                    complexCompositor.setComplexCompositorKind(ComplexCompositorKind.CHOICE);
                    break;
                }
                case 2: {
                    complexCompositor.setComplexCompositorKind(ComplexCompositorKind.SEQUENCE);
                    break;
                }
            }
        }
    }

    private static void setUpSchemaElementAttribute(PlatformFactory platformFactory, SchemaElement schemaElement, ISchemaAttribute[] schemaAttributes, EList<SchemaElement> schemaElements) {
        ISchemaAttribute[] iSchemaAttributeArray = schemaAttributes;
        int n = schemaAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            ISchemaAttribute iSchemaAttribute = iSchemaAttributeArray[n2];
            ConfigurationElementAttribute configurationElementAttribute = platformFactory.createConfigurationElementAttribute();
            configurationElementAttribute.setName(iSchemaAttribute.getName());
            int currentSchemaAttributeType = iSchemaAttribute.getKind();
            String typeName = iSchemaAttribute.getType().getName();
            ConfigurationElementAttributeKind kind = ExtensionPointServices.getKindForThisSetting(typeName, currentSchemaAttributeType);
            configurationElementAttribute.setType(kind);
            if (iSchemaAttribute.getBasedOn() != null) {
                String _extends;
                String basedOn = iSchemaAttribute.getBasedOn();
                String[] splitResult = basedOn.split(":");
                if (splitResult.length == 2) {
                    _extends = splitResult[0];
                    String _implements = splitResult[1];
                    if (_extends.length() > 0 && _implements.length() > 0) {
                        configurationElementAttribute.setBasedOn("extends : " + _extends + " ; implements : " + _implements);
                    } else {
                        configurationElementAttribute.setBasedOn("implements : " + _implements);
                    }
                } else if (splitResult.length == 1 && basedOn.contains(":")) {
                    _extends = basedOn;
                    configurationElementAttribute.setBasedOn("extends : " + _extends);
                } else if (splitResult.length == 1) {
                    String _implements = basedOn;
                    configurationElementAttribute.setBasedOn("implements : " + _implements);
                }
            }
            configurationElementAttribute.setTranslatable(iSchemaAttribute.isTranslatable());
            schemaElement.getAttributes().add((Object)configurationElementAttribute);
            ++n2;
        }
    }

    private static ConfigurationElementAttributeKind getKindForThisSetting(String typeName, int currentSchemaAttributeType) {
        if (typeName.equals("string")) {
            switch (currentSchemaAttributeType) {
                case 1: {
                    return ConfigurationElementAttributeKind.JAVA;
                }
                case 0: {
                    return ConfigurationElementAttributeKind.STRING;
                }
                case 3: {
                    return ConfigurationElementAttributeKind.IDENTIFIER;
                }
                case 2: {
                    return ConfigurationElementAttributeKind.RESOURCE;
                }
            }
            return null;
        }
        if (typeName.equals("boolean")) {
            switch (currentSchemaAttributeType) {
                case 0: {
                    return ConfigurationElementAttributeKind.BOOLEAN;
                }
            }
            return null;
        }
        if (typeName.equals("int")) {
            switch (currentSchemaAttributeType) {
                case 0: {
                    return ConfigurationElementAttributeKind.INTEGER;
                }
            }
            return null;
        }
        if (typeName.equals("anyURI")) {
            return ConfigurationElementAttributeKind.RESOURCE;
        }
        return null;
    }

    public static void sortExtensionPoints(EList<ExtensionPoint> extensionPoints) {
        ExtensionPoint[] extensionPointArray = (ExtensionPoint[])extensionPoints.toArray();
        ExtensionPointsComparator ExtensionPointsComparator2 = new ExtensionPointsComparator();
        Arrays.sort(extensionPointArray, ExtensionPointsComparator2);
        extensionPoints.clear();
        ExtensionPoint[] extensionPointArray2 = extensionPointArray;
        int n = extensionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExtensionPoint extensionPoint = extensionPointArray2[n2];
            extensionPoints.add((Object)extensionPoint);
            ++n2;
        }
    }
}

