/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.modelresources.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.model.common.share.modelresources.exceptions.ModelResourceException;
import org.polarsys.kitalpha.model.common.share.modelresources.impl.ModelResource;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.IModelResource;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.IModelResources;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.ModelResourceState;

public class ModelResources
implements IModelResources {
    private final Logger LOGGER = Logger.getLogger(ModelResource.class);
    private final Map<URI, IModelResource> modelResources = new HashMap<URI, IModelResource>();
    private List<EObject> allModelEObjects = null;

    @Override
    public Map<URI, IModelResource> getModelResources() {
        return this.modelResources;
    }

    @Override
    public List<IModelResource> filterModelResourcesWithState(ModelResourceState state) {
        Collection<IModelResource> allModelResources = this.getModelResources().values();
        ArrayList<IModelResource> result = new ArrayList<IModelResource>();
        for (IModelResource iModelResource : allModelResources) {
            ModelResourceState r_state = iModelResource.getResourceState();
            if (!r_state.equals((Object)state)) continue;
            result.add(iModelResource);
        }
        return result;
    }

    @Override
    public List<URI> getAllModelResourceURI() {
        return new ArrayList<URI>(this.getModelResources().keySet());
    }

    @Override
    public List<IModelResource> getAllModelResources() {
        return new ArrayList<IModelResource>(this.getModelResources().values());
    }

    @Override
    public List<URI> getModelResourceURIWithState(ModelResourceState state) {
        Collection<IModelResource> allModelResources = this.getModelResources().values();
        ArrayList<URI> result = new ArrayList<URI>();
        for (IModelResource iModelResource : allModelResources) {
            ModelResourceState r_state = iModelResource.getResourceState();
            if (!r_state.equals((Object)state)) continue;
            try {
                result.add(iModelResource.getResourceURI());
            }
            catch (ModelResourceException e) {
                this.LOGGER.warn((Object)e.getMessage());
            }
        }
        return result;
    }

    @Override
    public List<EObject> getAllResourcesEObjects() {
        if (this.allModelEObjects == null) {
            this.allModelEObjects = new ArrayList<EObject>();
            Collection<IModelResource> allModelResources = this.getModelResources().values();
            for (IModelResource iModelResource : allModelResources) {
                try {
                    this.allModelEObjects.addAll(iModelResource.getModelObjects());
                }
                catch (ModelResourceException e) {
                    this.LOGGER.warn((Object)e.getMessage());
                }
            }
            return this.allModelEObjects;
        }
        return this.allModelEObjects;
    }

    @Override
    public void addResource(URI uri, IModelResource modelResource) {
        this.getModelResources().put(uri, modelResource);
    }

    @Override
    public IModelResource getModelResource(URI uri) {
        return this.getModelResources().get(uri);
    }

    @Override
    public List<IModelResource> getAllDeletionCandidates() {
        List<IModelResource> allResources = this.getAllModelResources();
        ArrayList<IModelResource> candidates = new ArrayList<IModelResource>();
        for (IModelResource iModelResource : allResources) {
            if (!iModelResource.isCandidate()) continue;
            candidates.add(iModelResource);
        }
        return candidates;
    }
}

