/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.ui.menu;

import java.util.List;
import java.util.Optional;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnInsertEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;
import org.polarsys.kitalpha.massactions.core.activator.MACoreActivator;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.ui.menu.MAMenuItemProviders;
import org.polarsys.kitalpha.massactions.visualize.column.QueryColumn;
import org.polarsys.kitalpha.massactions.visualize.data.accessor.MVColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.visualize.extensions.columnprovider.QueryColumnProvider;
import org.polarsys.kitalpha.massactions.visualize.helpers.LayerExtractionHelper;
import org.polarsys.kitalpha.massactions.visualize.query.IQuery;
import org.polarsys.kitalpha.massactions.visualize.query.QueryRegistry;
import org.polarsys.kitalpha.massactions.visualize.table.layer.groupby.IMVGroupByLayer;

public class MVMenuItemProviders
extends MAMenuItemProviders {
    private static final String SWITCH_PERSPECTIVE_COLUMN_MENU_ITEM_TEXT = "Switch perspective";
    private static final String CREATE_QUERY_COLUMN_MENU_ITEM_TEXT = "Select a column query";

    protected MVMenuItemProviders() {
    }

    public static IMenuItemProvider createQueryColumnMenuItemProvider() {
        return MVMenuItemProviders.createQueryColumnMenuItemProvider(CREATE_QUERY_COLUMN_MENU_ITEM_TEXT);
    }

    public static IMenuItemProvider createQueryColumnMenuItemProvider(String menuText) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(menuText);
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IMVGroupByLayer groupByLayer = LayerExtractionHelper.extractGroupByLayer(natTable);
                    IMABodyLayer bodyLayer = groupByLayer.getGridLayer().getBodyLayer();
                    IMAColumnPropertyAccessor columnPropertyAccessor = bodyLayer.getColumnPropertyAccessor();
                    List columnProviders = columnPropertyAccessor.getColumnProviders();
                    Optional<QueryColumnProvider> queryColumnProvider = columnProviders.stream().filter(p -> p instanceof QueryColumnProvider).map(p -> (QueryColumnProvider)((Object)p)).findFirst();
                    queryColumnProvider.ifPresent(p -> {
                        int[] selectedColumnPositions = bodyLayer.getSelectionLayer().getSelectedColumnPositions();
                        IQuery query = QueryRegistry.getInstance().getQuery("XXX");
                        QueryColumn queryColumn = new QueryColumn();
                        queryColumn.setBodyLayer(bodyLayer);
                        queryColumn.setQuery(query);
                        queryColumn.setParameterColumnPositions(selectedColumnPositions);
                        p.addColumn(queryColumn);
                        groupByLayer.dataChanged(columnPropertyAccessor.getCurrentDataRepresentation());
                        DataLayer bodyDataLayer = groupByLayer.getGridLayer().getBodyLayer().getBodyDataLayer();
                        int newColumnPosition = bodyLayer.getColumnHideShowLayer().getColumnCount();
                        bodyDataLayer.fireLayerEvent((ILayerEvent)new ColumnInsertEvent((ILayer)bodyDataLayer, newColumnPosition));
                    });
                }
            });
        };
    }

    public static IMenuItemProvider createSwitchPerspectiveColumnMenuItemProvider() {
        return MVMenuItemProviders.createSwitchPerspectiveColumnMenuItemProvider(SWITCH_PERSPECTIVE_COLUMN_MENU_ITEM_TEXT);
    }

    public static IMenuItemProvider createSwitchPerspectiveColumnMenuItemProvider(String menuText) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(menuText);
            menuItem.setEnabled(true);
            menuItem.setImage(MACoreActivator.getDefault().getImageRegistry().get("IMAGE_SWITCH_PERSPECTIVE"));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MVColumnPropertyAccessor columnPropertyAccessor = (MVColumnPropertyAccessor)LayerExtractionHelper.extractBodyLayer(natTable).getColumnPropertyAccessor();
                    columnPropertyAccessor.switchPerspective();
                }
            });
        };
    }
}

