/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.diffmerge.bridge.integration.transposer;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.polarsys.kitalpha.diffmerge.bridge.integration.transposer.Messages;
import org.polarsys.kitalpha.transposer.transformation.context.TransformationKey;

public class TransposerBridgeCause
implements ICause.Symbolic<Object> {
    private final TransformationKey _transformationKey;

    public TransposerBridgeCause(TransformationKey key_p) {
        if (key_p == null) {
            throw new IllegalArgumentException(Messages.bridgeLoggerTransposerBridgeTransformationKeyNullIllegalArgument);
        }
        if (key_p.getSourceObject() == null) {
            throw new IllegalArgumentException(Messages.bridgeLoggerTransposerBridgeTransformationKeySourceObjectNullIllegalArgument);
        }
        if (key_p.getRole() == null) {
            throw new IllegalArgumentException(Messages.bridgeLoggerTransposerBridgeTransformationKeyRoleNullIllegalArgument);
        }
        this._transformationKey = key_p;
    }

    public boolean equals(Object other_p) {
        boolean result = false;
        if (other_p instanceof TransposerBridgeCause) {
            TransposerBridgeCause peer = (TransposerBridgeCause)other_p;
            result = this._transformationKey.equals((Object)peer.getTransformationKey());
        }
        return result;
    }

    public TransformationKey getTransformationKey() {
        return this._transformationKey;
    }

    public String getRole() {
        return this.getTransformationKey().getRole();
    }

    public Object getSource() {
        return this.getTransformationKey().getSourceObject();
    }

    public Collection<Object> getSourceElements() {
        return Collections.singleton(this.getSource());
    }

    public Object getSymbol(ISymbolFunction function_p) {
        String result = null;
        Object sourceIdentification = function_p.getSymbol(this.getSource());
        if (sourceIdentification != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Source[");
            builder.append(sourceIdentification);
            builder.append("]Role[");
            builder.append(this.getRole());
            builder.append(']');
            result = builder.toString();
        }
        return result;
    }

    public int hashCode() {
        return this._transformationKey.hashCode();
    }
}

