/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.emf.toolbox.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.emf.toolbox.api.TransposerUtil;
import org.polarsys.kitalpha.transposer.emf.toolbox.api.dangling.IGenericDanglingConstants;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.transformation.emf.resource.ResourceUtil;

public class ModelInitializer
implements IActivity,
ITransposerWorkflow,
IGenericDanglingConstants {
    public static final String ID = "org.polarsys.kitalpha.transposer.emf.toolbox.activities.models.initializer";
    public static final String NSURI = "nsUri";
    public static final String NSURI_DESCRIPTION = "nsUri of the metamodel";
    public static final String ROOT_ELEMENT = "EClass name";
    public static final String DANGLING_ELEMENT_DESCRIPTION = "the name of the EClass that contains all elements created";

    public IStatus run(ActivityParameters activityParams_p) {
        URI fileURI;
        Resource resource;
        Collection selection = (Collection)activityParams_p.getParameter("TransposerSelection").getValue();
        String nsUri = (String)activityParams_p.getParameter(NSURI).getValue();
        String rootS = (String)activityParams_p.getParameter(ROOT_ELEMENT).getValue();
        EObject root = TransposerUtil.createObject(nsUri, rootS);
        String extension = root.eClass().getEPackage().getName().toLowerCase();
        IContext context = (IContext)activityParams_p.getParameter("TransposerContext").getValue();
        String modelPath = "";
        if (selection == null || selection.isEmpty()) {
            return new Status(4, "org.polarsys.kitalpha.transposer.emf.toolbox", "the selection is empty or null");
        }
        Object selectedElement = selection.iterator().next();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (selectedElement instanceof IFile && (resource = new ResourceSetImpl().getResource(fileURI = URI.createPlatformResourceURI((String)((IFile)selectedElement).getFullPath().toString(), (boolean)true), true)).getContents() != null && !resource.getContents().isEmpty()) {
            EObject project = (EObject)resource.getContents().get(0);
            selectedElement = project;
            selection.clear();
            selection.add(project);
        }
        if (selectedElement instanceof EObject && ((EObject)selectedElement).eResource() != null) {
            Resource res = ((EObject)selectedElement).eResource();
            String path = res.getURI().toPlatformString(true);
            modelPath = String.valueOf(res.getURI().toPlatformString(true).substring(0, path.length() - res.getURI().fileExtension().length())) + extension;
        }
        ResourceUtil.createResource((ResourceSet)resourceSet, (String)modelPath, null, (boolean)false);
        ((Resource)resourceSet.getResources().get(0)).setTrackingModification(true);
        context.put((Object)"TransposerResourceSet", (Object)resourceSet);
        return Status.OK_STATUS;
    }

    public Collection<DeclaredParameter> getParameters() {
        ArrayList<DeclaredParameter> params = new ArrayList<DeclaredParameter>();
        DeclaredParameter param = new DeclaredParameter(NSURI, "", NSURI_DESCRIPTION);
        params.add(param);
        param = new DeclaredParameter(ROOT_ELEMENT, "", DANGLING_ELEMENT_DESCRIPTION);
        params.add(param);
        return params;
    }

    public Map<String, ParameterError<?>> validateParameters(ActivityParameters valuedParameters_p) {
        HashMap errors = new HashMap();
        boolean isValid = false;
        String nsUri = (String)valuedParameters_p.getParameter(NSURI).getValue();
        isValid = EPackage.Registry.INSTANCE.containsKey((Object)nsUri);
        if (!isValid) {
            DeclaredParameter p = (DeclaredParameter)valuedParameters_p.getParameter(NSURI);
            errors.put(NSURI, new ParameterError((GenericParameter)p, "This uri doesn't exist"));
        }
        if (isValid) {
            EClassifier classifier;
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
            String root = (String)valuedParameters_p.getParameter(ROOT_ELEMENT).getValue();
            if (root != null && (classifier = ePackage.getEClassifier(root)) == null) {
                DeclaredParameter p = (DeclaredParameter)valuedParameters_p.getParameter(ROOT_ELEMENT);
                errors.put(NSURI, new ParameterError((GenericParameter)p, "This EClass doesn't exist for this URI"));
            }
        }
        return errors;
    }
}

