/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ServiceSet;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IServiceHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointManager;

public class ViewpointServiceHandler
extends ViewpointManager.ElementHandler
implements IServiceHandler {
    public ViewpointServiceHandler(Viewpoint viewpoint, ViewpointManager mgr) {
        super(viewpoint, mgr);
    }

    private ServiceSet getCurrentServiceSet() {
        if (this.getViewpoint().getServiceSet() == null) {
            ServiceSet serviceSet = ViewpointFactory.eINSTANCE.createServiceSet();
            serviceSet.setTarget(this.getViewpoint());
            serviceSet.setVpid(EcoreUtil.generateUUID());
            this.getViewpoint().setServiceSet(serviceSet);
        }
        return this.getViewpoint().getServiceSet();
    }

    @Override
    public void removeServices(List<Service> services) {
        for (Service service : services) {
            if (!this.isRemovable((ViewpointElement)service)) continue;
            ServiceSet set = (ServiceSet)service.eContainer();
            set.getNewServices().remove((Object)service);
        }
        this.saveModel();
    }

    @Override
    public void createService(String id, String name, String type, List<Rule> rules) {
        ServiceSet set = this.getCurrentServiceSet();
        Service service = ViewpointFactory.eINSTANCE.createService();
        set.getNewServices().add((Object)service);
        service.setName(name);
        service.setId(id);
        service.setType(type);
        service.setVpid(EcoreUtil.generateUUID());
        service.getRelatedRules().addAll(rules);
        this.saveModel();
    }

    @Override
    public List<ViewpointElement> getElements() {
        ArrayList<ViewpointElement> services = new ArrayList<ViewpointElement>();
        services.addAll((Collection<ViewpointElement>)this.getViewpoint().getServices());
        return services;
    }

    @Override
    public List<ViewpointElement> getElementsFromParents() {
        HashMap<String, ViewpointElement> name2prop = new HashMap<String, ViewpointElement>();
        for (Viewpoint vp : this.getViewpoint().getAllParents()) {
            for (ViewpointElement elt : vp.getServices()) {
                name2prop.put(this.getIdentifier(elt), elt);
            }
        }
        return new ArrayList<ViewpointElement>(name2prop.values());
    }
}

