/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.editing;

import java.lang.reflect.Method;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.BasicEditingSupport;

public abstract class AbstractStringEditingSupport
extends BasicEditingSupport {
    protected static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected static final Class<?>[] STRING_ARRAY = new Class[]{String.class};
    protected Method getter;
    protected Method setter;

    public AbstractStringEditingSupport(ColumnViewer viewer, Class<?> candidate, String propertyName) {
        super(viewer);
        String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            this.getter = candidate.getMethod(getterName, EMPTY_CLASS_ARRAY);
            this.setter = candidate.getMethod(setterName, STRING_ARRAY);
        }
        catch (Exception e) {
            AD_Log.getDefault().logInfo(NLS.bind((String)Messages.EditingSupport_error1, (Object)propertyName), (Throwable)e);
        }
    }

    @Override
    protected void doSetValue(Object element, Object value) {
        try {
            this.setter.invoke(element, value);
        }
        catch (Exception e) {
            AD_Log.getDefault().logError((Throwable)e);
        }
    }

    @Override
    protected boolean canEdit(Object element) {
        if (this.setter == null || this.getter == null) {
            return false;
        }
        return super.canEdit(element);
    }

    protected Object getValue(Object element) {
        try {
            Object value = this.getter.invoke(element, EMPTY_OBJECT_ARRAY);
            return value == null ? "" : value;
        }
        catch (Exception e) {
            AD_Log.getDefault().logError((Throwable)e);
            return "";
        }
    }
}

