/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.ui.validation.constraints;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.IAdditionalConstraint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.ValidationStatus;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UI;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIDescription;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIField;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.ui.validation.message.Messages;

public class UniqueUIFieldNameInSection
implements IAdditionalConstraint {
    private String duplicatedName = "";

    public boolean isObjectInScope(Object object) {
        return object instanceof UIField;
    }

    public ValidationStatus validationRules(Object data) {
        this.duplicatedName = "";
        UIField current = (UIField)data;
        if (current.getName() == null) {
            return ValidationStatus.Ok;
        }
        List<UIContainer> allAvailableSections = this.getAllAvailableSections(current);
        for (UIContainer uiContainer : allAvailableSections) {
            if (!this.duplicateFieldsName(uiContainer, current)) continue;
            return ValidationStatus.Error;
        }
        return ValidationStatus.Ok;
    }

    private boolean duplicateFieldsName(UIContainer parent, UIField referenceObject) {
        for (UIField uiField : parent.getUI_fields()) {
            String curName = uiField.getName();
            String referencedName = referenceObject.getName();
            if (uiField == referenceObject || referencedName == null || curName == null || !curName.toLowerCase().equals(referencedName.toLowerCase())) continue;
            this.duplicatedName = curName;
            return true;
        }
        boolean error = false;
        for (UIContainer uiContainer : parent.getSubContainers()) {
            if (uiContainer.getName().toLowerCase().equals(referenceObject.getName().toLowerCase())) {
                this.duplicatedName = referenceObject.getName();
                return true;
            }
            error = this.duplicateFieldsName(uiContainer, referenceObject);
            if (!error) continue;
            return true;
        }
        return false;
    }

    private List<UIContainer> getAllAvailableSections(UIField uiField) {
        BasicEList result = new BasicEList();
        EObject current = uiField.eContainer();
        while (!(current instanceof UIDescription)) {
            current = current.eContainer();
        }
        UIDescription uiDescription = (UIDescription)current;
        for (UI ui : uiDescription.getUIs()) {
            EList ui_Containers = ui.getUI_Containers();
            if (ui_Containers.isEmpty()) continue;
            result.addAll((Collection)ui_Containers);
        }
        return result;
    }

    public String getMessage(ValidationStatus status, Object eObject) {
        return Messages.bind((String)Messages.Validation_UIField_Unique_NameInSection, (Object)this.duplicatedName);
    }
}

