/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.viewpointActivityExplorer.ViewpointActivityExplorer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Configuration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdiagram.DiagramSet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices.ServiceSet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIDescription;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.services.VpspecGrammarAccess;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.CommonTemplateProposalProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.output.TreeAppendable;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint;

public class VpspecTemplateProposalProvider
extends CommonTemplateProposalProvider {
    private static final String VARIABLE_NAME = "${aspectName}";
    private static final int DATA_PRIORITY = 90;
    private static final int UI_PRIORITY = 80;
    private static final int DIAGRAM_PRIORITY = 70;
    private static final int ACTIVITYEXPLORER_PRIORITY = 60;
    private static final int SERVICES_PRIORITY = 50;
    private static final int BUILD_PRIORITY = 40;
    private static final int CONFIGURATION_PRIORITY = 30;
    @Inject
    private IGrammarAccess grammar;

    @Inject
    public VpspecTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.templateStore = templateStore;
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        if (this.grammar instanceof VpspecGrammarAccess) {
            Template template;
            Template[] templates;
            VpspecGrammarAccess access = (VpspecGrammarAccess)this.grammar;
            TemplateContextType contextType = templateContext.getContextType();
            Template[] templateArray = templates = this.templateStore.getTemplates(contextType.getId());
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                template = templateArray[n2];
                if (this.isNewAspectTemplate(template.getContextTypeId())) {
                    template = this.buildTemplate(template, context, template.getContextTypeId());
                    break;
                }
                ++n2;
            }
            templateArray = templates;
            n = templates.length;
            n2 = 0;
            while (n2 < n) {
                template = templateArray[n2];
                if (!acceptor.canAcceptMoreTemplates()) {
                    return;
                }
                if (this.validate(template, templateContext)) {
                    String text;
                    INode currentNode;
                    INode nextSibling;
                    TemplateProposal proposal = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
                    EObject current = context.getCurrentModel();
                    String contextTypeId = template.getContextTypeId();
                    if (current != null && current instanceof Viewpoint) {
                        Data data = ((Viewpoint)current).getVP_Data();
                        if (data != null && contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Data")) {
                            return;
                        }
                        EList vp_Aspects = ((Viewpoint)current).getVP_Aspects();
                        for (Aspect candidate : vp_Aspects) {
                            if (candidate instanceof ServiceSet && contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Services")) {
                                return;
                            }
                            if (candidate instanceof Configuration && contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Configuration")) {
                                return;
                            }
                            if (candidate instanceof UIDescription && contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_UI")) {
                                return;
                            }
                            if (candidate instanceof DiagramSet && contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Diagrams")) {
                                return;
                            }
                            if (!(candidate instanceof ViewpointActivityExplorer) || !contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Activity-Explorer")) continue;
                            return;
                        }
                    }
                    if (contextTypeId.matches("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_" + access.getViewpointAccess().getTypeDiagramsKeyword_15_0_0().getValue()) && (nextSibling = (currentNode = context.getCurrentNode()).getNextSibling()) != null && (text = nextSibling.getText()).equals(access.getViewpointAccess().getTypeUIKeyword_14_0_0().getValue())) {
                        return;
                    }
                    acceptor.accept(proposal);
                }
                ++n2;
            }
        }
    }

    private boolean isNewAspectTemplate(String templateIdentifier) {
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Build")) {
            return true;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Configuration")) {
            return true;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Data")) {
            return true;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Diagrams")) {
            return true;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Services")) {
            return true;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_UI")) {
            return true;
        }
        return templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Activity-Explorer");
    }

    private Template buildTemplate(Template template, ContentAssistContext context, String templateId) {
        EObject current = context.getCurrentModel();
        if (current instanceof Viewpoint) {
            String shortName = ((Viewpoint)current).getShortName();
            TreeAppendable appendable = new TreeAppendable(current, "\t", "\n");
            appendable.append((CharSequence)this.getTemplatePattern(templateId, shortName));
            template.setPattern(appendable.getContent());
            return template;
        }
        return null;
    }

    protected String getTemplatePattern(String templateIdentifier, String shortName) {
        VpspecGrammarAccess access = (VpspecGrammarAccess)this.grammar;
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Data")) {
            return String.valueOf(access.getViewpointAccess().getDataKeyword_13_0().getValue()) + " " + VARIABLE_NAME;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Diagrams")) {
            return String.valueOf(access.getViewpointAccess().getTypeDiagramsKeyword_15_0_0().getValue()) + " " + VARIABLE_NAME;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_UI")) {
            return String.valueOf(access.getViewpointAccess().getTypeUIKeyword_14_0_0().getValue()) + " " + VARIABLE_NAME;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Services")) {
            return String.valueOf(access.getViewpointAccess().getTypeServicesKeyword_17_0_0().getValue()) + " " + VARIABLE_NAME;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Build")) {
            return String.valueOf(access.getViewpointAccess().getTypeBuildKeyword_18_0_0().getValue()) + " " + VARIABLE_NAME;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Configuration")) {
            return String.valueOf(access.getViewpointAccess().getTypeConfigurationKeyword_19_0_0().getValue()) + " " + VARIABLE_NAME;
        }
        if (templateIdentifier.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Activity-Explorer")) {
            return String.valueOf(access.getViewpointAccess().getTypeActivityExplorerKeyword_16_0_0().getValue()) + " " + VARIABLE_NAME;
        }
        return null;
    }

    public int getRelevance(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Build")) {
            return 40;
        }
        if (contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Configuration")) {
            return 30;
        }
        if (contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Data")) {
            return 90;
        }
        if (contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Diagrams")) {
            return 70;
        }
        if (contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Services")) {
            return 50;
        }
        if (contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_UI")) {
            return 80;
        }
        if (contextTypeId.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec.kw_Activity-Explorer")) {
            return 60;
        }
        return super.getRelevance(template);
    }
}

