/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.kitalpha.ad.ta.extension.TargetApplicationExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Configuration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.GenerationConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.TargetApplication;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.VpconfFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.preference.helper.ViewpointDslPreferencesHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.exceptions.CantConcreteSyntaxResourceCreator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.extensions.ConcreteSyntaxResourceCreationManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.utils.ProjectsManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.utils.VPDescModelManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards.NewDSLVpProjectPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards.NewDSLVpProjectSecondPage;

public class NewDSLVpProjectWizard
extends Wizard
implements INewWizard {
    private final StringBuffer PLUGIN_XML_HEADER = new StringBuffer().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<?eclipse version=\"3.4\"?>\n").append("<plugin>\n");
    private final StringBuffer PLUGIN_XML_FOOTER = new StringBuffer().append("</plugin>\n");
    protected String taRootProjectName;
    protected String taRootNsURI;
    protected String vpTargetApplication;
    protected String vpShortName;
    protected String vpRootProjectName;
    protected String vpDescriptionProjectName;
    protected String vpNsURI;
    private boolean generateNsURI = true;
    protected Map<String, String> selectedConcreteSyntaxCreators;
    protected NewDSLVpProjectPage page;
    protected NewDSLVpProjectSecondPage sPage;
    protected ISelection selection;
    protected IProgressMonitor monitor;
    protected ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.kitalpha.ad.viewpoint.dsl.services.project", (String)"icons/project_new_wizard.png");

    public NewDSLVpProjectWizard() {
        this.setWindowTitle(Messages.Wizard_New);
        super.setDefaultPageImageDescriptor(this.image);
        super.setNeedsProgressMonitor(true);
    }

    protected void setGenerateNsUri(boolean generate) {
        this.generateNsURI = generate;
    }

    public void setVpTargetApplication(String vpTargetApplication) {
        this.checkStringArgument(vpTargetApplication, "Target application name");
        this.vpTargetApplication = vpTargetApplication;
        this.taRootProjectName = !ViewpointDslPreferencesHelper.useTargetApplicationValue() ? ViewpointDslPreferencesHelper.getCustomizedRPNValue() : TargetApplicationExtensionManager.getRootProjectName((String)this.vpTargetApplication).toLowerCase();
        this.taRootNsURI = TargetApplicationExtensionManager.getRootNsUri((String)this.vpTargetApplication).toLowerCase();
        this.updateViewpointData();
    }

    private void updateViewpointData() {
        if (this.vpTargetApplication != null && this.vpTargetApplication.trim().length() > 0 && this.vpShortName != null && this.vpShortName.trim().length() > 0) {
            this.setVpRootProjectName(String.valueOf(this.taRootProjectName) + "." + this.vpShortName);
            this.setVpDescriptionProjectName(String.valueOf(this.getVpRootProjectName()) + ".vpdsl");
            if (this.generateNsURI) {
                String nsUri = this.taRootNsURI.endsWith("/") ? String.valueOf(this.taRootNsURI) + this.vpShortName : String.valueOf(this.taRootNsURI) + "/" + this.vpShortName;
                this.setVpNsURI(nsUri);
            }
        }
    }

    public String getVpTargetApplication() {
        return this.vpTargetApplication;
    }

    public String getVpShortName() {
        return this.vpShortName;
    }

    public void setVpShortName(String vpShortName) {
        this.checkStringArgument(vpShortName, "Viewpoint short name");
        this.vpShortName = vpShortName;
        this.updateViewpointData();
    }

    public String getVpRootProjectName() {
        return this.vpRootProjectName;
    }

    public void setVpRootProjectName(String vpRootProjectName) {
        this.checkStringArgument(vpRootProjectName, "Viewpoint root project name");
        this.vpRootProjectName = vpRootProjectName.toLowerCase();
    }

    public void setVpDescriptionProjectName(String vpDescriptionProjectName) {
        this.checkStringArgument(vpDescriptionProjectName, "Viewpoint description project name");
        this.vpDescriptionProjectName = vpDescriptionProjectName.toLowerCase();
    }

    public String getVpDescriptionProjectName() {
        return this.vpDescriptionProjectName;
    }

    public String getTaNsURI() {
        return this.taRootNsURI;
    }

    public void setTaNsURI(String nsURI) {
        this.checkStringArgument(nsURI, "Target application root nsuri");
        this.taRootNsURI = nsURI;
    }

    public String getVpNsURI() {
        return this.vpNsURI;
    }

    public void setVpNsURI(String nsURI) {
        this.checkStringArgument(nsURI, "Viewpoint nsuri");
        this.vpNsURI = nsURI;
    }

    public Map<String, String> getSelectedConcreteSyntaxCreators() {
        return this.selectedConcreteSyntaxCreators;
    }

    public void setSelectedConcreteSyntaxCreators(Map<String, String> selectedConcreteSyntaxCreators) {
        this.selectedConcreteSyntaxCreators = selectedConcreteSyntaxCreators;
    }

    private void checkStringArgument(String arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument : " + argName + " can't be null");
        }
        if (arg.trim().length() == 0) {
            throw new IllegalArgumentException("Argument : " + argName + " must have a value");
        }
    }

    protected void addFirstPage() {
        this.page = new NewDSLVpProjectPage(this.selection);
        this.page.setTitle(Messages.Wizard_Page_First_Title);
        this.page.setDescription(Messages.Wizard_Page_First_Description);
        this.addPage((IWizardPage)this.page);
    }

    protected void addSecondPage() {
        this.sPage = new NewDSLVpProjectSecondPage(this.selection);
        this.sPage.setTitle(Messages.Wizard_Page_Second_Title);
        this.sPage.setDescription(Messages.Wizard_Page_Second_Description);
        this.addPage((IWizardPage)this.sPage);
    }

    public void addPages() {
        super.addPages();
        this.addFirstPage();
        this.addSecondPage();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        StringBuffer contributorsExtensions;
                        IProject project = NewDSLVpProjectWizard.this.createVpDslProject(monitor);
                        Viewpoint vp = NewDSLVpProjectWizard.this.createVpsSpecModel(project, monitor);
                        StringBuffer vpdslModelReuseExtension = NewDSLVpProjectWizard.this.createVpDslModelReuseExtension();
                        NewDSLVpProjectWizard.this.appendPluginExtension(vpdslModelReuseExtension);
                        boolean csRresourceCreated = NewDSLVpProjectWizard.this.createConcretSyntaxResources(monitor);
                        if (!csRresourceCreated) {
                            NewDSLVpProjectWizard.this.openVpDescDefaultEditor(vp);
                        }
                        if ((contributorsExtensions = NewDSLVpProjectWizard.this.createConcretSyntaxExtensions(monitor)) != null && contributorsExtensions.length() > 0) {
                            NewDSLVpProjectWizard.this.appendPluginExtension(contributorsExtensions);
                        }
                        monitor.done();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    protected IProject createVpDslProject(IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(Messages.Wizard_VpDslProject_Creation_Task_Name, 1);
        IProject prj = ProjectsManager.createProject(this.vpDescriptionProjectName, this.vpShortName, monitor);
        monitor.worked(1);
        return prj;
    }

    protected Viewpoint createVpsSpecModel(IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(Messages.Wizard_VpSpecModel_CreationTask_Name, 1);
        EObject vpConf = this.createConfigurationExtension();
        Viewpoint vp = VPDescModelManager.createVpsSpecModel(project, this.page.getVpShortName(), true, null, vpConf);
        monitor.worked(1);
        return vp;
    }

    private EObject createConfigurationExtension() {
        String nsuri;
        Configuration vpConf = VpconfFactory.eINSTANCE.createConfiguration();
        TargetApplication targetApp = VpconfFactory.eINSTANCE.createTargetApplication();
        targetApp.setType(this.vpTargetApplication);
        GenerationConfiguration genCof = VpconfFactory.eINSTANCE.createGenerationConfiguration();
        genCof.setProjectName(this.vpRootProjectName);
        String string = this.generateNsURI ? String.valueOf(this.taRootNsURI) + this.vpShortName : (nsuri = this.vpNsURI != null && this.vpNsURI.trim().length() > 0 ? this.vpNsURI : String.valueOf(this.taRootNsURI) + this.vpShortName);
        if (this.generateNsURI || this.vpNsURI == null || this.vpNsURI != null && this.vpNsURI.trim().length() == 0) {
            this.vpNsURI = nsuri;
        }
        genCof.setNsuri(nsuri);
        vpConf.getVpConfigurationElements().add((Object)targetApp);
        vpConf.getVpConfigurationElements().add((Object)genCof);
        vpConf.setName(String.valueOf(this.vpShortName) + ".conf");
        return vpConf;
    }

    protected boolean createConcretSyntaxResources(IProgressMonitor monitor) {
        boolean result = false;
        if (this.selectedConcreteSyntaxCreators != null && this.selectedConcreteSyntaxCreators.size() != 0) {
            monitor.beginTask(Messages.Wizard_ConcreteSyntax_Creation_SubTask, this.selectedConcreteSyntaxCreators.size());
            Set<String> set = this.selectedConcreteSyntaxCreators.keySet();
            for (String id : set) {
                try {
                    monitor.subTask("creation of " + id + " resource");
                    boolean csCreated = ConcreteSyntaxResourceCreationManager.createAdditionalResource(id, this.vpShortName, this.vpTargetApplication, this.vpRootProjectName, this.vpDescriptionProjectName, this.vpNsURI);
                    monitor.worked(1);
                    if (!csCreated) continue;
                    result = csCreated;
                }
                catch (CantConcreteSyntaxResourceCreator e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    protected void appendPluginExtension(StringBuffer extension) throws CoreException {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.vpDescriptionProjectName);
        final IFile pluginXml = project.getFile("plugin.xml");
        if (!pluginXml.exists()) {
            this.createPluginXml(extension, this.monitor);
        }
        Scanner scanner = new Scanner(pluginXml.getContents());
        StringBuffer newPluginXml = new StringBuffer();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.equals("</plugin>") || line.contains("</plugin>")) break;
            newPluginXml.append(String.valueOf(line) + "\n");
        }
        scanner.close();
        newPluginXml.append("\n");
        newPluginXml.append(extension);
        newPluginXml.append("\n");
        newPluginXml.append(this.PLUGIN_XML_FOOTER);
        final ByteArrayInputStream fileInputStream = new ByteArrayInputStream(newPluginXml.toString().getBytes());
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    if (pluginXml.exists()) {
                        pluginXml.setContents((InputStream)fileInputStream, true, false, null);
                    } else {
                        pluginXml.create((InputStream)fileInputStream, true, null);
                    }
                    project.refreshLocal(2, monitor);
                }
            }.run(this.monitor);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    protected void createPluginXml(StringBuffer extensions, IProgressMonitor monitor) {
        StringBuffer pluginXmlContent = new StringBuffer();
        pluginXmlContent.append(this.PLUGIN_XML_HEADER);
        pluginXmlContent.append("\n");
        pluginXmlContent.append(extensions);
        pluginXmlContent.append("\n");
        pluginXmlContent.append(this.PLUGIN_XML_FOOTER);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.vpDescriptionProjectName);
        final ByteArrayInputStream fileInputStream = new ByteArrayInputStream(pluginXmlContent.toString().getBytes());
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IFile pluginXml = project.getFile("plugin.xml");
                    if (pluginXml.exists()) {
                        pluginXml.setContents((InputStream)fileInputStream, true, false, null);
                    } else {
                        pluginXml.create((InputStream)fileInputStream, true, null);
                    }
                    project.refreshLocal(2, monitor);
                }
            }.run(monitor);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    protected StringBuffer createVpDslModelReuseExtension() {
        String modelPath = "/" + this.vpDescriptionProjectName + "/model/" + this.vpShortName + ".vpdesc";
        StringBuffer content = new StringBuffer();
        content.append("\t<extension\n");
        content.append("\t     point=\"org.polarsys.kitalpha.resourcereuse.resources\">\n");
        content.append("\t  <resource\n");
        content.append("\t        domain=\"vpdsl\"\n");
        content.append("\t        id=\"").append(this.vpDescriptionProjectName).append(".description").append("\"\n");
        content.append("\t        tags=\"vpdesc\"\n");
        content.append("\t        name=\"").append(this.vpShortName.toLowerCase()).append("\"\n");
        content.append("\t        path=\"").append(modelPath).append("\"/>\n");
        content.append("\t</extension>\n");
        return content;
    }

    protected StringBuffer createConcretSyntaxExtensions(IProgressMonitor monitor) {
        StringBuffer result = null;
        if (this.selectedConcreteSyntaxCreators != null && this.selectedConcreteSyntaxCreators.size() != 0) {
            result = new StringBuffer();
            monitor.beginTask(Messages.Wizard_ConcreteSyntax_Creation_SubTask, this.selectedConcreteSyntaxCreators.size());
            Set<String> set = this.selectedConcreteSyntaxCreators.keySet();
            for (String id : set) {
                try {
                    monitor.subTask("creation of " + id + " contribution");
                    StringBuffer content = ConcreteSyntaxResourceCreationManager.createAdditionalPluginXmlContribution(id, this.vpShortName, this.vpTargetApplication, this.vpRootProjectName, this.vpDescriptionProjectName, this.vpNsURI);
                    if (content != null) {
                        result.append(content);
                        result.append("\n");
                    }
                    monitor.worked(1);
                }
                catch (CantConcreteSyntaxResourceCreator e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    protected void openVpDescDefaultEditor(Viewpoint vp) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)new Path(vp.eResource().getURI().toPlatformString(true)));
        if (file != null) {
            try {
                IDE.openEditor((IWorkbenchPage)workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

