/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.ad.ta.extension.TargetApplicationExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.utils.NamesValidityChecker;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards.DefaultWizardSelection;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards.NewDSLVpProjectWizard;

public class NewDSLVpProjectPage
extends WizardPage {
    private Text _vpShortNameText;
    private Combo _targetapplicationListCombo;
    private ISelection iSelection;

    public NewDSLVpProjectPage(ISelection selection) {
        super(Messages.Wizard_Page1_Title);
        this.iSelection = selection;
    }

    public NewDSLVpProjectPage() {
        super(Messages.Wizard_Page1_Title);
    }

    public void createControl(Composite parent) {
        Composite compo = this.createMainComposite(parent);
        this.setControl((Control)compo);
        this.vpDataChanged();
    }

    protected Composite createMainComposite(Composite parent) {
        Composite compo = new Composite(parent, 0);
        compo.setLayoutData((Object)new GridData(768));
        compo.setLayout((Layout)new GridLayout(2, false));
        Label vpName = new Label(compo, 0);
        vpName.setText(Messages.Wizard_Page1_Label_ShortName);
        this._vpShortNameText = new Text(compo, 2052);
        this._vpShortNameText.setLayoutData((Object)new GridData(768));
        this._vpShortNameText.setFocus();
        this._vpShortNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDSLVpProjectPage.this.vpDataChanged();
                ((NewDSLVpProjectWizard)NewDSLVpProjectPage.this.getWizard()).setVpShortName(NewDSLVpProjectPage.this._vpShortNameText.getText());
            }
        });
        String initialShortName = ((NewDSLVpProjectWizard)this.getWizard()).getVpShortName();
        if (initialShortName != null && initialShortName.trim().length() > 0) {
            this._vpShortNameText.setText(initialShortName);
        }
        Label targetapplicationListLabel = new Label(compo, 0);
        targetapplicationListLabel.setText(Messages.Wizard_Page1_Label_TargetApplication);
        this._targetapplicationListCombo = new Combo(compo, 8);
        this._targetapplicationListCombo.setItems(TargetApplicationExtensionManager.getSupportedTargetApplication());
        this._targetapplicationListCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewDSLVpProjectPage.this.vpDataChanged();
                ((NewDSLVpProjectWizard)NewDSLVpProjectPage.this.getWizard()).setVpTargetApplication(NewDSLVpProjectPage.this._targetapplicationListCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int i = 0;
        String[] stringArray = this._targetapplicationListCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (DefaultWizardSelection.isDefault(item, 0)) {
                this._targetapplicationListCombo.select(i);
                ((NewDSLVpProjectWizard)this.getWizard()).setVpTargetApplication(this._targetapplicationListCombo.getText());
                break;
            }
            ++i;
            ++n2;
        }
        return compo;
    }

    private boolean vpDataChanged() {
        String msg = Messages.Wizard_Page1_DataCheck_AllowedCharacter;
        if (this._vpShortNameText != null && !NamesValidityChecker.isValid(this._vpShortNameText.getText(), false)) {
            this.updateStatus(String.valueOf(Messages.Wizard_Page1_DataCheck_VPShortName_Invalid) + msg);
            return false;
        }
        if (this._targetapplicationListCombo != null && (this._targetapplicationListCombo.getText().trim().length() == 0 || this._targetapplicationListCombo.getText().equals(Messages.Wizard_Page1_NoTargetApplication))) {
            this.updateStatus(Messages.Wizard_Page1_DataCheck_TargetApplication_NoSelection);
            return false;
        }
        this.updateStatus(null);
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public void setVpShortName(String shortName) {
        this._vpShortNameText.setText(shortName);
    }

    public String getVpShortName() {
        return this._vpShortNameText.getText();
    }
}

