/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class CommonTemplateStore
extends TemplateStore {
    private static final String TEMPLATEPROVIDER_EXTENSIONPOINT = "org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.common.ui.templateprovider";
    private static final String TEMPLATEPROVIDER_CONFIGELEMENT = "TemplateProvider";
    private final URL resourceTemplate;
    protected final Plugin plugin;
    protected static final Logger log = Logger.getLogger(CommonTemplateStore.class);

    @Inject
    public CommonTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, @Named(value="languageName") String key, AbstractUIPlugin plugin) {
        super(registry, store, String.valueOf(key) + ".templates");
        this.plugin = plugin;
        this.resourceTemplate = this.getTemplateFileURL();
        try {
            this.load();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    protected URL getTemplateFileURL() {
        Map<Bundle, String> templateStores = this.lookupTemplateStores();
        if (templateStores.size() > 1) {
            log.info((Object)"Multiple template stores are declared, loading default templates instead");
            return this.plugin.getBundle().getEntry("templates/templates.xml");
        }
        Iterator<Bundle> iterator = templateStores.keySet().iterator();
        if (iterator.hasNext()) {
            Bundle provider = iterator.next();
            return provider.getEntry(templateStores.get(provider));
        }
        return null;
    }

    protected void loadContributedTemplates() throws IOException {
        if (this.resourceTemplate == null) {
            return;
        }
        TemplateReaderWriter reader = new TemplateReaderWriter();
        InputStream openStream = null;
        try {
            openStream = this.resourceTemplate.openStream();
            try {
                TemplatePersistenceData[] read;
                TemplatePersistenceData[] templatePersistenceDataArray = read = reader.read(openStream, null);
                int n = read.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n2];
                    this.internalAdd(templatePersistenceData);
                    ++n2;
                }
            }
            finally {
                openStream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public Map<Bundle, String> lookupTemplateStores() {
        HashMap<Bundle, String> templateStores = new HashMap<Bundle, String>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATEPROVIDER_EXTENSIONPOINT);
        if (config.length != 0) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigElement = iConfigurationElementArray[n2];
                if (iConfigElement.getName().equalsIgnoreCase(TEMPLATEPROVIDER_CONFIGELEMENT)) {
                    Bundle bundle = Platform.getBundle((String)iConfigElement.getContributor().getName());
                    templateStores.put(bundle, iConfigElement.getAttribute("file"));
                }
                ++n2;
            }
        }
        return templateStores;
    }

    protected void handleException(IOException x) {
        log.error((Object)x.getMessage(), (Throwable)x);
    }
}

