/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.column.primitive;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.polarsys.kitalpha.massactions.core.column.AbstractMAColumn;
import org.polarsys.kitalpha.massactions.core.helper.CommonFeaturesHelper;
import org.polarsys.kitalpha.massactions.core.helper.DisplayConverterHelper;
import org.polarsys.kitalpha.massactions.core.helper.container.PossibleFeature;

public class MAPrimitiveColumn
extends AbstractMAColumn {
    protected PossibleFeature possibleFeature;
    protected Map<String, EStructuralFeature> featureMap;

    public void setPossibleFeature(PossibleFeature possibleFeature) {
        this.possibleFeature = possibleFeature;
        this.id = this.name = possibleFeature.getFeatureName();
    }

    @Override
    public void dataChanged(Collection<EObject> data) {
        this.featureMap = CommonFeaturesHelper.getAllClassStructuralFeatures(data, this.possibleFeature);
    }

    @Override
    protected IDisplayConverter createDisplayConverter() {
        return DisplayConverterHelper.getDisplayConverter(this.possibleFeature.getFeatureType());
    }

    @Override
    public Object getDataValue(EObject rowObject) {
        EStructuralFeature rowObjectFeature = this.getStructuralFeature(rowObject);
        return rowObject.eGet(rowObjectFeature);
    }

    @Override
    public void setDataValue(EObject rowObject, Object newValue) {
        EStructuralFeature rowObjectFeature = this.getStructuralFeature(rowObject);
        rowObject.eSet(rowObjectFeature, newValue);
    }

    protected EStructuralFeature getStructuralFeature(EObject rowObject) {
        String rowObjectEClass = rowObject.eClass().getName();
        return this.featureMap.get(rowObjectEClass);
    }

    public PossibleFeature getPossibleFeature() {
        return this.possibleFeature;
    }
}

