/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.table.layer.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.column.IMAColumnHeaderLayer;

public class MAColumnHeaderLayer
extends AbstractLayerTransform
implements IMAColumnHeaderLayer {
    private static final String AT_INDEX = "] at index [";
    private static final Log log = LogFactory.getLog(MAColumnHeaderLayer.class);
    protected final IMABodyLayer bodyLayerStack;
    protected final IConfigRegistry configRegistry;
    protected IMAColumnPropertyAccessor columnPropertyAccessor;
    protected IDataProvider columnHeaderDataProvider;
    protected ColumnHeaderLayer columnHeaderLayer;
    protected ColumnGroupModel columnGroupModel;
    protected ColumnGroupHeaderLayer columnGroupHeaderLayer;
    protected DefaultColumnHeaderDataLayer columnHeaderDataLayer;
    protected GlazedListsSortModel<EObject> sortModel;
    protected FilterRowHeaderComposite<EObject> filterRowHeaderLayer;
    protected SortHeaderLayer<EObject> sortHeaderLayer;
    protected GroupByModel groupByModel;

    public MAColumnHeaderLayer(IMABodyLayer bodyLayerStack, IConfigRegistry configRegistry) {
        this.bodyLayerStack = bodyLayerStack;
        this.configRegistry = configRegistry;
        ILayer finalLayer = this.initializeLayer();
        this.setUnderlyingLayer(finalLayer);
    }

    protected ILayer initializeLayer() {
        this.columnPropertyAccessor = this.bodyLayerStack.getColumnPropertyAccessor();
        this.configureBodyLayerLabels();
        String[] columnNames = this.columnPropertyAccessor.getColumnPropertiesArray();
        this.columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(columnNames);
        this.columnHeaderDataLayer = new DefaultColumnHeaderDataLayer(this.columnHeaderDataProvider);
        this.columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.columnHeaderDataLayer, (ILayer)this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        this.columnGroupModel = new ColumnGroupModel();
        this.columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)this.columnHeaderLayer, this.bodyLayerStack.getSelectionLayer(), this.columnGroupModel);
        this.configureColumnHeaderLayerLabels();
        this.sortModel = new GlazedListsSortModel(this.bodyLayerStack.getSortedList(), (IColumnPropertyAccessor)this.columnPropertyAccessor, this.configRegistry, (ILayer)this.columnHeaderDataLayer);
        this.sortHeaderLayer = new SortHeaderLayer((ILayer)this.columnHeaderLayer, this.sortModel, false);
        DefaultGlazedListsFilterStrategy filterStrategy = new DefaultGlazedListsFilterStrategy(this.bodyLayerStack.getFilterList(), (IColumnAccessor)this.bodyLayerStack.getColumnPropertyAccessor(), this.configRegistry);
        this.filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)filterStrategy, this.sortHeaderLayer, this.columnHeaderDataProvider, this.configRegistry);
        this.initColumnChooserHandler();
        return this.filterRowHeaderLayer;
    }

    @Override
    public void dataChanged(Collection<EObject> data) {
        this.configureBodyLayerLabels();
        String[] columnNames = this.columnPropertyAccessor.getColumnPropertiesArray();
        this.columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(columnNames);
        this.columnHeaderDataLayer.setDataProvider(this.columnHeaderDataProvider);
        this.configureColumnHeaderLayerLabels();
        this.updateSortedColumns();
        this.updateFilteredColumns();
        this.updateReorderedColumns();
        this.updateHiddenColumns();
        this.bodyLayerStack.notifyListeners();
    }

    protected void configureBodyLayerLabels() {
        ColumnLabelAccumulator columnLabelAccumulator = new ColumnLabelAccumulator(this.bodyLayerStack.getBodyDataProvider());
        this.bodyLayerStack.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
    }

    protected void configureColumnHeaderLayerLabels() {
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)this.columnHeaderDataLayer);
        this.columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        List<IMAColumn> columnList = this.columnPropertyAccessor.getColumnList();
        int i = 0;
        while (i < columnList.size()) {
            IMAColumn column = columnList.get(i);
            labelAccumulator.registerColumnOverrides(i, new String[]{column.getSortLabel()});
            ++i;
        }
    }

    protected void updateSortedColumns() {
        List<String> prevColumnProperties = this.columnPropertyAccessor.getPrevColumnProperties();
        List prevSortedColumns = this.sortModel.getSortedColumnIndexes();
        List prevDirections = prevSortedColumns.stream().map(arg_0 -> this.sortModel.getSortDirection(arg_0)).collect(Collectors.toList());
        int i = 0;
        while (i < prevSortedColumns.size()) {
            int prevColumnIndex = (Integer)prevSortedColumns.get(i);
            String prevColumnName = prevColumnProperties.get(prevColumnIndex);
            int currColumnIndex = this.columnPropertyAccessor.getColumnIndex(prevColumnName);
            if (currColumnIndex != prevColumnIndex) {
                this.sortModel.sort(prevColumnIndex, SortDirectionEnum.NONE, false);
                log.info((Object)("Removing sorted column [" + prevColumnName + AT_INDEX + prevColumnIndex + "]"));
                if (currColumnIndex != -1) {
                    SortDirectionEnum prevSortDirection = (SortDirectionEnum)prevDirections.get(i);
                    this.sortModel.sort(currColumnIndex, prevSortDirection, false);
                    log.info((Object)("Adding sorted column [" + prevColumnName + AT_INDEX + currColumnIndex + "]"));
                }
            }
            ++i;
        }
    }

    protected void updateFilteredColumns() {
        List<String> prevColumnProperties = this.columnPropertyAccessor.getPrevColumnProperties();
        FilterRowDataProvider filterRowDataProvider = this.filterRowHeaderLayer.getFilterRowDataLayer().getFilterRowDataProvider();
        HashMap<Integer, Object> prevFilteredColumns = new HashMap<Integer, Object>(filterRowDataProvider.getFilterIndexToObjectMap());
        filterRowDataProvider.clearAllFilters();
        prevFilteredColumns.forEach((prevColumnIndex, filterPattern) -> {
            String prevColumnName = (String)prevColumnProperties.get((int)prevColumnIndex);
            int currColumnIndex = this.columnPropertyAccessor.getColumnIndex(prevColumnName);
            if (currColumnIndex != -1) {
                filterRowDataProvider.setDataValue(currColumnIndex, 1, filterPattern);
                log.info((Object)("Adding filter [" + filterPattern + "] for column [" + prevColumnName + AT_INDEX + currColumnIndex + "]"));
            }
        });
    }

    protected void updateReorderedColumns() {
        boolean columnChange;
        boolean bl = columnChange = this.columnPropertyAccessor.getColumnProperties().size() < this.columnPropertyAccessor.getPrevColumnProperties().size();
        if (columnChange) {
            List defaultIndexOrder = IntStream.range(0, this.columnPropertyAccessor.getColumnCount()).boxed().collect(Collectors.toList());
            ColumnReorderLayer columnReorderLayer = this.bodyLayerStack.getColumnReorderLayer();
            columnReorderLayer.getColumnIndexOrder().clear();
            columnReorderLayer.getColumnIndexOrder().addAll(defaultIndexOrder);
            log.info((Object)"Reseting reordered columns");
        }
    }

    protected void updateHiddenColumns() {
        List<String> prevColumnProperties = this.columnPropertyAccessor.getPrevColumnProperties();
        ColumnHideShowLayer columnHideShowLayer = this.bodyLayerStack.getColumnHideShowLayer();
        ArrayList prevHiddenColumnIndexes = new ArrayList(columnHideShowLayer.getHiddenColumnIndexes());
        HashSet<Integer> currToHideColumnIndexes = new HashSet<Integer>();
        int i = 0;
        while (i < prevHiddenColumnIndexes.size()) {
            int prevHiddenColumnIndex = (Integer)prevHiddenColumnIndexes.get(i);
            String prevColumnName = prevColumnProperties.get(prevHiddenColumnIndex);
            int currColumnIndex = this.columnPropertyAccessor.getColumnIndex(prevColumnName);
            if (currColumnIndex != -1) {
                currToHideColumnIndexes.add(currColumnIndex);
            }
            ++i;
        }
        if (currToHideColumnIndexes.size() != prevHiddenColumnIndexes.size() || !currToHideColumnIndexes.containsAll(prevHiddenColumnIndexes)) {
            columnHideShowLayer.showAllColumns();
            if (currToHideColumnIndexes.size() < this.columnPropertyAccessor.getColumnCount()) {
                List currToHideColumnPositions = currToHideColumnIndexes.stream().map(arg_0 -> ((ColumnHideShowLayer)columnHideShowLayer).getColumnPositionByIndex(arg_0)).collect(Collectors.toList());
                columnHideShowLayer.hideColumnPositions(currToHideColumnPositions);
                log.info((Object)("Hiding [" + currToHideColumnIndexes.size() + "] columns"));
            }
        }
    }

    private void initColumnChooserHandler() {
        DisplayColumnChooserCommandHandler columnChooserCommandHandler = new DisplayColumnChooserCommandHandler(this.bodyLayerStack.getSelectionLayer(), this.bodyLayerStack.getColumnHideShowLayer(), this.columnHeaderLayer, (DataLayer)this.columnHeaderDataLayer, this.columnGroupHeaderLayer, this.columnGroupModel);
        this.bodyLayerStack.getViewportLayer().registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
    }

    @Override
    public IDataProvider getColumnHeaderDataProvider() {
        return this.columnHeaderDataProvider;
    }

    @Override
    public SortHeaderLayer<EObject> getSortHeaderLayer() {
        return this.sortHeaderLayer;
    }

    @Override
    public FilterRowHeaderComposite<EObject> getFilterHeaderLayer() {
        return this.filterRowHeaderLayer;
    }
}

