/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.examples.basic.ecore.workflow.activities;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.cadence.examples.basic.ecore.workflow.Activator;

public class SaveAllocationModel
implements IActivity {
    private static final String ALLOCATION_MODEL_PARAMETER_NAME = "allocationModel";
    private static final String SEMANTIC_MODEL_PARAMETER_NAME = "semanticModel";
    private static final String SUFFIX_DESCRIPTION = "The suffix for the copy of the allocation model.";
    private static final String SUFFIX_VALUE = "_temp";
    private static final String FILE_NAME_SUFFIX_NAME = "File name suffix";
    private Collection<DeclaredParameter> cdp = new HashSet<DeclaredParameter>();

    public SaveAllocationModel() {
        DeclaredParameter suffix = new DeclaredParameter(FILE_NAME_SUFFIX_NAME, SUFFIX_VALUE, SUFFIX_DESCRIPTION);
        this.cdp.add(suffix);
    }

    public Collection<DeclaredParameter> getParameters() {
        return this.cdp;
    }

    public IStatus run(ActivityParameters activityParams_p) {
        IStatus status = Status.OK_STATUS;
        List semanticModelRoot = (List)activityParams_p.getParameter(SEMANTIC_MODEL_PARAMETER_NAME).getValue();
        EObject allocationModel = (EObject)activityParams_p.getParameter(ALLOCATION_MODEL_PARAMETER_NAME).getValue();
        EObject semanticModel = (EObject)semanticModelRoot.get(0);
        Resource semanticModelResource = semanticModel.eResource();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        String modelname = semanticModelResource.getURI().toPlatformString(true);
        String suffix = "";
        GenericParameter declaredParameter = activityParams_p.getParameter(FILE_NAME_SUFFIX_NAME);
        suffix = (String)declaredParameter.getValue();
        String extension = String.valueOf(suffix) + "." + allocationModel.eClass().getEPackage().getName().toString();
        URI fileURI = URI.createPlatformResourceURI((String)modelname.replaceAll(semanticModelResource.getURI().fileExtension(), extension), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)allocationModel);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            status = new Status(4, "org.polarsys.kitalpha.cadence.examples.basic.ecore.workflow", e.getMessage());
            Activator.getDefault().getLog().log(status);
        }
        return status;
    }

    public Map<String, ParameterError<?>> validateParameters(ActivityParameters valuedParameters_p) {
        HashMap errors = new HashMap();
        GenericParameter declaredParameter = valuedParameters_p.getParameter(FILE_NAME_SUFFIX_NAME);
        String suffix = (String)declaredParameter.getValue();
        if (suffix.equals("") || !Pattern.matches("[(\\w|_)*]*", suffix)) {
            String reason = "The suffix can't contain any charaters except : a-z, 0-9 and _ ";
            if (suffix.equals("")) {
                reason = "You should define a suffix";
            }
            ParameterError badValue = new ParameterError(declaredParameter, reason);
            errors.put(FILE_NAME_SUFFIX_NAME, badValue);
        }
        return errors;
    }
}

