/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.callback;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateProposalProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.generator.IViewpointSynchronizer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.callback.CommonEditorCallback;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.callback.VpspecMessages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.VpspecTemplateContextType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.util.ReferenceUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.AbstractWizard;

public class VpspecEditorCallback
extends CommonEditorCallback {
    private ICompletionListener autoCompletionListener = null;
    private Listener autoCompletionSelectionListener = null;
    private String selectedProposal = null;
    private boolean contentAssistOn = false;
    @Inject
    ITemplateProposalProvider templateProvider;
    @Inject
    XtextTemplateContextType contextType;
    private final List<AspectAddedListener> listeners = new ArrayList<AspectAddedListener>();

    public void afterCreatePartControl(XtextEditor editor) {
        super.afterCreatePartControl(editor);
        this.installCompletionListener();
        if (this.contextType instanceof VpspecTemplateContextType) {
            this.addListener((VpspecTemplateContextType)this.contextType);
        }
    }

    private void installCompletionListener() {
        if (this.getCurrentEditor() != null) {
            XtextSourceViewer viewer = (XtextSourceViewer)this.getCurrentEditor().getInternalSourceViewer();
            this.autoCompletionListener = new ICompletionListener(){

                public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                    VpspecEditorCallback.this.selectedProposal = proposal.getDisplayString();
                }

                public void assistSessionStarted(ContentAssistEvent event) {
                    VpspecEditorCallback.this.contentAssistOn = true;
                }

                public void assistSessionEnded(ContentAssistEvent event) {
                    if (VpspecEditorCallback.this.selectedProposal != null) {
                        VpspecEditorCallback.this.applySelectedProposal();
                        VpspecEditorCallback.this.selectedProposal = null;
                    }
                    VpspecEditorCallback.this.contentAssistOn = false;
                }
            };
            viewer.getContentAssistantFacade().addCompletionListener(this.autoCompletionListener);
            this.autoCompletionSelectionListener = new Listener(){

                public void handleEvent(Event event) {
                    Widget item;
                    if (VpspecEditorCallback.this.contentAssistOn && (item = event.item) instanceof TableItem) {
                        VpspecEditorCallback.this.selectedProposal = ((TableItem)item).getText();
                    }
                }
            };
            viewer.getControl().getDisplay().addFilter(13, this.autoCompletionSelectionListener);
        }
    }

    private void applySelectedProposal() {
        String wizardId = this.getWizardFromProposal();
        if (wizardId != null) {
            String fileName = this.openWizard(wizardId);
            this.notifyResolvers(fileName);
        }
    }

    public void addListener(AspectAddedListener list) {
        this.listeners.add(list);
    }

    public void removeListener(EventListener list) {
        this.listeners.remove(list);
    }

    protected void notifyResolvers(String fileName) {
        for (AspectAddedListener list : this.listeners) {
            list.notifyResolver(fileName);
        }
    }

    public String openWizard(String id) {
        IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
        try {
            IWorkbenchWizard wizard;
            if (descriptor != null && (wizard = descriptor.createWizard()) instanceof AbstractWizard) {
                AbstractWizard wiz = (AbstractWizard)wizard;
                Object[] segments = new Object[]{(IFile)this.getCurrentEditor().getEditorInput().getAdapter(IFile.class)};
                TreeSelection selection = new TreeSelection(new TreePath(segments));
                wiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                Display display = PlatformUI.getWorkbench().getDisplay();
                WizardDialog wizardDialog = new WizardDialog(display.getActiveShell(), (IWizard)wiz);
                wizardDialog.setTitle(wiz.getWindowTitle());
                wizardDialog.open();
                int returnCode = wizardDialog.getReturnCode();
                return returnCode == 0 ? wiz.getFileName() : null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void beforeDispose(XtextEditor editor) {
        super.beforeDispose(editor);
        this.uninstallCompletionListener();
        this.removeListener((VpspecTemplateContextType)this.contextType);
    }

    protected boolean doSynchronize(IFile file) {
        boolean result = false;
        XtextResourceSet resourceSet = (XtextResourceSet)this.getInjector().getInstance(XtextResourceSet.class);
        IViewpointSynchronizer generator = (IViewpointSynchronizer)this.getInjector().getInstance(IViewpointSynchronizer.class);
        String projectName = this.getProject(file).getName();
        EObject targetObject = ResourceHelper.loadStandaloneResource((ResourceSet)resourceSet, (String)projectName);
        if (targetObject != null) {
            Viewpoint targetVp = (Viewpoint)targetObject;
            List resourceEObjects = ResourceHelper.validateAndloadResource((IFile)file, (ResourceSet)resourceSet);
            if (!resourceEObjects.isEmpty()) {
                EObject synchronizedObject;
                List inputObjects;
                EObject primaryResourceRoot = (EObject)resourceEObjects.get(0);
                if (primaryResourceRoot instanceof org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint) {
                    org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint sourceVp = (org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)primaryResourceRoot;
                    this.initTargetViewpoint(sourceVp, targetVp);
                    ReferenceUtil.setTargetReferences((org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)sourceVp, (Viewpoint)targetVp, (ResourceSet)resourceSet);
                }
                if (this.validate(inputObjects = this.loadInputModels(file, (ResourceSet)resourceSet)) && (synchronizedObject = generator.synchronize(inputObjects, (EObject)targetVp)) != null) {
                    try {
                        HashMap<String, String> saveOptions = new HashMap<String, String>();
                        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                        synchronizedObject.eResource().save(saveOptions);
                        result = true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            System.err.println("Error Loading standalone resource");
        }
        resourceSet.eSetDeliver(false);
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
        return result;
    }

    private void initTargetViewpoint(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint source, Viewpoint target) {
        if (source != null && target != null) {
            target.setName(source.getName());
            target.setShortName(source.getShortName());
        }
    }

    private void uninstallCompletionListener() {
        if (this.getCurrentEditor() != null) {
            XtextSourceViewer viewer = (XtextSourceViewer)this.getCurrentEditor().getInternalSourceViewer();
            viewer.getContentAssistantFacade().removeCompletionListener(this.autoCompletionListener);
            viewer.getControl().getDisplay().removeFilter(13, this.autoCompletionSelectionListener);
        }
    }

    private String getWizardFromProposal() {
        if (this.selectedProposal.equals(VpspecMessages.VpspecEditorCallback_NewBuild)) {
            return "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.vpbuild.file";
        }
        if (this.selectedProposal.equals(VpspecMessages.VpspecEditorCallback_NewConfiguration)) {
            return "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.vpconf.file";
        }
        if (this.selectedProposal.equals(VpspecMessages.VpspecEditorCallback_NewData)) {
            return "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.data.file";
        }
        if (this.selectedProposal.equals(VpspecMessages.VpspecEditorCallback_NewDiagrams)) {
            return "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.vpdiagram.file";
        }
        if (this.selectedProposal.equals(VpspecMessages.VpspecEditorCallback_NewServices)) {
            return "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.vpservices.file";
        }
        if (this.selectedProposal.equals(VpspecMessages.VpspecEditorCallback_NewUserInterface)) {
            return "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.vpui.file";
        }
        if (this.selectedProposal.equals(VpspecMessages.VpspecEditorCallback_newActivityExplorer)) {
            return "org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.activityexplorer.file";
        }
        return null;
    }

    public static interface AspectAddedListener
    extends EventListener {
        public void notifyResolver(String var1);
    }
}

