/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.polarsys.kitalpha.resourcereuse.helper.Disposable;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReader;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.registry.ResourceRegistry;

public class ModelBasedRegistry
extends ResourceRegistry {
    protected final Map<String, Set<String>> bundle2resource = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> bundle2concern = new HashMap<String, Set<String>>();
    private final ResourceReader reader;

    public ModelBasedRegistry(ResourceRegistry parent, ResourceReader reader) {
        super(parent);
        this.reader = reader;
    }

    public ModelBasedRegistry(ResourceRegistry parent) {
        this(parent, null);
    }

    public void clear(String bundleId) {
        Set<String> set = this.bundle2resource.get(bundleId);
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                this.id2resource.remove(string);
            }
            set.clear();
        }
        if ((set = this.bundle2concern.get(bundleId)) != null && !set.isEmpty()) {
            for (Map.Entry entry : this.user2concern.entrySet()) {
                for (String concern : (Set)entry.getValue()) {
                    if (!set.contains(concern)) continue;
                    ((Set)entry.getValue()).remove(concern);
                }
            }
            for (Map.Entry entry : this.used2concern.entrySet()) {
                for (String concern : (Set)entry.getValue()) {
                    if (!set.contains(concern)) continue;
                    ((Set)entry.getValue()).remove(concern);
                }
            }
            set.clear();
        }
    }

    public void addResource(String bundleId, Resource res) {
        this.addResource(res);
        Set<String> resources = this.bundle2resource.get(bundleId);
        if (resources == null) {
            resources = new HashSet<String>();
            this.bundle2resource.put(bundleId, resources);
        }
        resources.add(res.getId());
    }

    public void addConcern(String bundleId, String concernName, String user, String used) {
        this.addConcern(concernName, user, used);
        Set<String> concerns = this.bundle2concern.get(bundleId);
        if (concerns == null) {
            concerns = new HashSet<String>();
            this.bundle2concern.put(bundleId, concerns);
        }
        concerns.add(concernName);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.reader != null && this.reader instanceof Disposable) {
            ((Disposable)((Object)this.reader)).dispose();
        }
        this.bundle2resource.clear();
        this.bundle2resource.clear();
    }
}

