/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.types;

import org.eclipse.emf.common.util.URI;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.exception.ViewpointResourceException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.message.Messages;

public class ResourceFileInformation {
    private final String PATH_SEPARATOR = "/";
    private String projectName_;
    private String folderName_;
    private String fileName_;
    private String fileExtension_;

    public ResourceFileInformation(String projectName, String folderName, String fileName, String fileExtension) throws ViewpointResourceException {
        if (!this.checkInforamtions()) {
            throw new RuntimeException(Messages.ResourceFileInformation_WrongInformation);
        }
        this.projectName_ = projectName;
        this.folderName_ = folderName;
        this.fileName_ = fileName;
        this.fileExtension_ = fileExtension;
    }

    public final URI getFileURI() {
        String strUri = this.getStringPath();
        return this.checkInforamtions() ? URI.createFileURI((String)strUri) : null;
    }

    public final URI getPlatformResourceURI() {
        String strUri = this.getStringPath();
        return this.checkInforamtions() ? URI.createPlatformResourceURI((String)strUri, (boolean)false) : null;
    }

    public final String getStringPath() {
        return "/" + this.projectName_ + "/" + this.folderName_ + "/" + this.getFileNameWithExtension(this.fileName_);
    }

    public final String getFileNameWithExtension(String resourceFileName) {
        if (resourceFileName.endsWith(this.fileExtension_)) {
            return resourceFileName;
        }
        return String.valueOf(resourceFileName) + "." + this.fileExtension_;
    }

    public boolean checkInforamtions() {
        return this.projectName_ != "" && this.folderName_ != "" && this.fileName_ != "" && this.fileExtension_ != "";
    }

    public String getProjectName() {
        return this.projectName_;
    }

    public void setProjectName(String projectName) {
        this.projectName_ = projectName;
    }

    public String getFolderName() {
        return this.folderName_;
    }

    public void setFolderName(String folderName) {
        this.folderName_ = folderName;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public void setFileName(String resourceName) {
        this.fileName_ = resourceName;
    }

    public String getFileExtension() {
        return this.fileExtension_;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension_ = fileExtension;
    }
}

